/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint.direct;

import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.direct.DirectConsumer;
import org.citrusframework.endpoint.direct.DirectSyncEndpointConfiguration;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageQueue;
import org.citrusframework.message.correlation.CorrelationManager;
import org.citrusframework.message.correlation.PollingCorrelationManager;
import org.citrusframework.messaging.ReplyProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DirectSyncConsumer
extends DirectConsumer
implements ReplyProducer {
    private static Logger log = LoggerFactory.getLogger(DirectSyncConsumer.class);
    private CorrelationManager<MessageQueue> correlationManager;
    private final DirectSyncEndpointConfiguration endpointConfiguration;

    public DirectSyncConsumer(String name, DirectSyncEndpointConfiguration endpointConfiguration) {
        super(name, endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
        this.correlationManager = new PollingCorrelationManager<MessageQueue>(endpointConfiguration, "Reply channel not set up yet");
    }

    @Override
    public Message receive(String selector, TestContext context, long timeout) {
        Message receivedMessage = super.receive(selector, context, timeout);
        this.saveReplyMessageQueue(receivedMessage, context);
        return receivedMessage;
    }

    public void send(Message message, TestContext context) {
        Assert.notNull((Object)message, (String)"Can not send empty message");
        String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.correlationManager.getCorrelationKey(correlationKeyName, context);
        MessageQueue replyQueue = (MessageQueue)this.correlationManager.find(correlationKey, this.endpointConfiguration.getTimeout());
        Assert.notNull((Object)replyQueue, (String)("Failed to find reply channel for message correlation key: " + correlationKey));
        if (log.isDebugEnabled()) {
            log.debug("Sending message to reply channel: '" + replyQueue + "'");
            log.debug("Message to send is:\n" + message.toString());
        }
        replyQueue.send(message);
        log.info("Message was sent to reply channel: '" + replyQueue + "'");
    }

    public void saveReplyMessageQueue(Message receivedMessage, TestContext context) {
        MessageQueue replyQueue = null;
        if (receivedMessage.getHeader("citrus_reply_queue") instanceof MessageQueue) {
            replyQueue = (MessageQueue)receivedMessage.getHeader("citrus_reply_queue");
        } else if (StringUtils.hasText((String)((String)receivedMessage.getHeader("citrus_reply_queue")))) {
            replyQueue = this.resolveQueueName(receivedMessage.getHeader("citrus_reply_queue").toString(), context);
        }
        if (replyQueue != null) {
            String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
            String correlationKey = this.endpointConfiguration.getCorrelator().getCorrelationKey(receivedMessage);
            this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
            this.correlationManager.store(correlationKey, (Object)replyQueue);
        } else {
            log.warn("Unable to retrieve reply message channel for message \n" + receivedMessage + "\n - no reply channel found in message headers!");
        }
    }

    public CorrelationManager<MessageQueue> getCorrelationManager() {
        return this.correlationManager;
    }

    public void setCorrelationManager(CorrelationManager<MessageQueue> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

