/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;
import org.citrusframework.message.Message;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class LoadMessageFunction
implements Function {
    public String execute(List<String> parameterList, TestContext context) {
        if (CollectionUtils.isEmpty(parameterList)) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        String messageName = parameterList.get(0);
        String messageHeader = null;
        if (messageName.endsWith(".body()")) {
            messageName = messageName.substring(0, messageName.indexOf(".body()"));
        } else if (messageName.contains(".header(") && messageName.endsWith(")")) {
            messageHeader = messageName.substring(messageName.indexOf(".header(") + 8, messageName.length() - 1);
            if (messageHeader.startsWith("'") && messageHeader.endsWith("'")) {
                messageHeader = messageHeader.substring(1, messageHeader.length() - 1);
            }
            if (!StringUtils.hasText((String)messageHeader)) {
                throw new CitrusRuntimeException("Missing header name in function parameter");
            }
            messageName = messageName.substring(0, messageName.indexOf(".header("));
        }
        Message stored = context.getMessageStore().getMessage(messageName);
        if (stored == null) {
            throw new CitrusRuntimeException(String.format("Failed to find stored message of name: '%s'", messageName));
        }
        if (StringUtils.hasText(messageHeader)) {
            Object headerValue = stored.getHeader(messageHeader);
            if (headerValue == null) {
                throw new CitrusRuntimeException(String.format("Failed to find header '%s' in stored message", messageHeader));
            }
            return headerValue.toString();
        }
        return (String)stored.getPayload(String.class);
    }
}

