/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.citrusframework.CitrusSettings;
import org.citrusframework.Completable;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class TestUtils {
    public static final String WAIT_THREAD_PREFIX = "citrus-waiting-";
    private static Logger log = LoggerFactory.getLogger(TestUtils.class);

    private TestUtils() {
    }

    public static void waitForCompletion(Completable container, TestContext context) {
        TestUtils.waitForCompletion(container, context, 10000L);
    }

    public static void waitForCompletion(Completable container, TestContext context, long timeout) {
        TestUtils.waitForCompletion(Executors.newSingleThreadScheduledExecutor(runnable -> TestUtils.createWaitingThread(runnable, context)), container, context, timeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void waitForCompletion(ScheduledExecutorService scheduledExecutor, Completable container, TestContext context, long timeout) {
        block10: {
            if (container.isDone(context)) {
                return;
            }
            ScheduledFuture<?> scheduler = null;
            try {
                CompletableFuture finished = new CompletableFuture();
                scheduler = scheduledExecutor.scheduleAtFixedRate(() -> {
                    try {
                        if (container.isDone(context)) {
                            finished.complete(true);
                        } else {
                            log.debug("Wait for test container to finish properly ...");
                        }
                    }
                    catch (Exception e) {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to wait for completion of nested test actions", (Throwable)e);
                        }
                        log.warn(String.format("Failed to wait for completion of nested test actions because of %s", e.getMessage()));
                    }
                }, 100L, timeout / 10L, TimeUnit.MILLISECONDS);
                finished.get(timeout, TimeUnit.MILLISECONDS);
                if (scheduler == null) break block10;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                try {
                    throw new CitrusRuntimeException("Failed to wait for test container to finish properly", (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (scheduler != null) {
                        scheduler.cancel(true);
                    }
                    try {
                        scheduledExecutor.shutdown();
                        scheduledExecutor.awaitTermination(timeout / 10L / 2L, TimeUnit.MICROSECONDS);
                    }
                    catch (InterruptedException e2) {
                        log.warn(String.format("Failed to await orderly termination of waiting tasks to complete, caused by %s", e2.getMessage()));
                    }
                    if (scheduledExecutor.isTerminated()) throw throwable;
                    scheduledExecutor.shutdownNow();
                    throw throwable;
                }
            }
            scheduler.cancel(true);
        }
        try {
            scheduledExecutor.shutdown();
            scheduledExecutor.awaitTermination(timeout / 10L / 2L, TimeUnit.MICROSECONDS);
        }
        catch (InterruptedException e) {
            log.warn(String.format("Failed to await orderly termination of waiting tasks to complete, caused by %s", e.getMessage()));
        }
        if (scheduledExecutor.isTerminated()) return;
        scheduledExecutor.shutdownNow();
    }

    public static String normalizeLineEndings(String text) {
        return text != null ? StringUtils.trimAllWhitespace((String)text.replace("\r\n", "\n").replace("&#13;\n", "\n")) : null;
    }

    private static Thread createWaitingThread(Runnable runnable, TestContext context) {
        Thread waitThread = Executors.defaultThreadFactory().newThread(runnable);
        if (context.getVariables().containsKey(CitrusSettings.TEST_NAME_VARIABLE)) {
            waitThread.setName(WAIT_THREAD_PREFIX.concat(context.getVariable(CitrusSettings.TEST_NAME_VARIABLE)).concat("-").concat(waitThread.getName()));
        } else {
            waitThread.setName(WAIT_THREAD_PREFIX.concat(waitThread.getName()));
        }
        return waitThread;
    }
}

