/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.variable.dictionary;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.AbstractMessageProcessor;
import org.citrusframework.variable.dictionary.DataDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public abstract class AbstractDataDictionary<T>
extends AbstractMessageProcessor
implements DataDictionary<T> {
    private static Logger log = LoggerFactory.getLogger(AbstractDataDictionary.class);
    private String name = ((Object)((Object)this)).getClass().getSimpleName();
    private boolean globalScope = true;
    protected Map<String, String> mappings = new LinkedHashMap<String, String>();
    protected Resource mappingFile;
    private DataDictionary.PathMappingStrategy pathMappingStrategy = DataDictionary.PathMappingStrategy.EXACT;

    protected <V> V convertIfNecessary(String value, V originalValue, TestContext context) {
        if (originalValue == null) {
            return (V)context.replaceDynamicContentInString(value);
        }
        return (V)context.getTypeConverter().convertIfNecessary((Object)context.replaceDynamicContentInString(value), originalValue.getClass());
    }

    public void initialize() {
        if (this.mappingFile != null) {
            Properties props;
            if (log.isDebugEnabled()) {
                log.debug("Reading data dictionary mapping " + this.mappingFile.getFilename());
            }
            try {
                props = PropertiesLoaderUtils.loadProperties((Resource)this.mappingFile);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString();
                if (log.isDebugEnabled()) {
                    log.debug("Loading data dictionary mapping: " + key + "=" + props.getProperty(key));
                }
                if (log.isDebugEnabled() && this.mappings.containsKey(key)) {
                    log.debug("Overwriting data dictionary mapping " + key + " old value:" + this.mappings.get(key) + " new value:" + props.getProperty(key));
                }
                this.mappings.put(key, props.getProperty(key));
            }
            log.debug("Loaded data dictionary mapping " + this.mappingFile.getFilename());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isGlobalScope() {
        return this.globalScope;
    }

    public void setGlobalScope(boolean scope) {
        this.globalScope = scope;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public Resource getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(Resource mappingFile) {
        this.mappingFile = mappingFile;
    }

    public DataDictionary.PathMappingStrategy getPathMappingStrategy() {
        return this.pathMappingStrategy;
    }

    public void setPathMappingStrategy(DataDictionary.PathMappingStrategy pathMappingStrategy) {
        this.pathMappingStrategy = pathMappingStrategy;
    }
}

