/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;

public class SystemPropertyFunction
implements Function {
    public String execute(List<String> parameterList, TestContext context) {
        if (parameterList == null || parameterList.isEmpty()) {
            throw new InvalidFunctionUsageException("Invalid function parameters - must set system property name");
        }
        String propertyName = parameterList.get(0);
        Optional<Object> defaultValue = parameterList.size() > 1 ? Optional.of(parameterList.get(1)) : Optional.empty();
        return Optional.ofNullable(System.getProperty(propertyName)).orElseGet(() -> (String)defaultValue.orElseThrow(() -> new CitrusRuntimeException(String.format("Failed to resolve system property '%s'", propertyName))));
    }
}

