/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ftp.client;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.RejectAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.keyprovider.ClassLoadableResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.scp.client.DefaultScpClientCreator;
import org.apache.sshd.scp.client.ScpClient;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.ftp.client.ScpEndpointConfiguration;
import org.citrusframework.ftp.client.SftpClient;
import org.citrusframework.ftp.message.FtpMessage;
import org.citrusframework.ftp.model.CommandType;
import org.citrusframework.ftp.model.DeleteCommand;
import org.citrusframework.ftp.model.GetCommand;
import org.citrusframework.ftp.model.ListCommand;
import org.citrusframework.ftp.model.PutCommand;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpClient
extends SftpClient {
    private static final Logger logger = LoggerFactory.getLogger(ScpClient.class);
    private org.apache.sshd.scp.client.ScpClient scpClient;

    public ScpClient() {
        this(new ScpEndpointConfiguration());
    }

    protected ScpClient(ScpEndpointConfiguration endpointConfiguration) {
        super(endpointConfiguration);
    }

    @Override
    public ScpEndpointConfiguration getEndpointConfiguration() {
        return (ScpEndpointConfiguration)super.getEndpointConfiguration();
    }

    @Override
    protected FtpMessage createDir(CommandType ftpCommand) {
        throw new UnsupportedOperationException("SCP client does not support create directory operation - please use sftp client");
    }

    @Override
    protected FtpMessage listFiles(ListCommand list, TestContext context) {
        throw new UnsupportedOperationException("SCP client does not support list files operation - please use sftp client");
    }

    @Override
    protected FtpMessage deleteFile(DeleteCommand delete, TestContext context) {
        throw new UnsupportedOperationException("SCP client does not support delete file operation - please use sftp client");
    }

    @Override
    protected FtpMessage storeFile(PutCommand command, TestContext context) {
        try {
            this.scpClient.upload(FileUtils.getFileResource((String)command.getFile().getPath(), (TestContext)context).getFile().getAbsolutePath(), command.getTarget().getPath(), new ScpClient.Option[0]);
        }
        catch (IOException e) {
            logger.error("Failed to store file via SCP", (Throwable)e);
            return FtpMessage.error();
        }
        return FtpMessage.success();
    }

    @Override
    protected FtpMessage retrieveFile(GetCommand command, TestContext context) {
        try {
            Resource target = FileUtils.getFileResource((String)command.getTarget().getPath(), (TestContext)context);
            if (!Optional.ofNullable(target.getFile().getParentFile()).map(File::mkdirs).orElse(true).booleanValue()) {
                logger.warn("Failed to create target directories in path: " + target.getFile().getAbsolutePath());
            }
            this.scpClient.download(command.getFile().getPath(), target.getFile().getAbsolutePath(), new ScpClient.Option[0]);
        }
        catch (IOException e) {
            logger.error("Failed to retrieve file via SCP", (Throwable)e);
            return FtpMessage.error();
        }
        return FtpMessage.success();
    }

    @Override
    protected void connectAndLogin() {
        try {
            SshClient client = SshClient.setUpDefaultClient();
            client.start();
            if (this.getEndpointConfiguration().isStrictHostChecking()) {
                client.setServerKeyVerifier((ServerKeyVerifier)new KnownHostsServerKeyVerifier((ServerKeyVerifier)RejectAllServerKeyVerifier.INSTANCE, FileUtils.getFileResource((String)this.getEndpointConfiguration().getKnownHosts()).getFile().toPath()));
            } else {
                client.setServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
            }
            ClientSession session = (ClientSession)((ConnectFuture)client.connect(this.getEndpointConfiguration().getUser(), this.getEndpointConfiguration().getHost(), this.getEndpointConfiguration().getPort()).verify(this.getEndpointConfiguration().getTimeout())).getSession();
            session.addPasswordIdentity(this.getEndpointConfiguration().getPassword());
            if (this.getPrivateKeyPath() != null) {
                Resource privateKey = FileUtils.getFileResource((String)this.getPrivateKeyPath());
                if (privateKey instanceof Resources.ClasspathResource) {
                    new ClassLoadableResourceKeyPairProvider(privateKey.getLocation()).loadKeys((SessionContext)session).forEach(arg_0 -> ((ClientSession)session).addPublicKeyIdentity(arg_0));
                } else {
                    new FileKeyPairProvider(privateKey.getFile().toPath()).loadKeys((SessionContext)session).forEach(arg_0 -> ((ClientSession)session).addPublicKeyIdentity(arg_0));
                }
            }
            session.auth().verify(this.getEndpointConfiguration().getTimeout());
            this.scpClient = new DefaultScpClientCreator().createScpClient(session);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException(String.format("Failed to login to SCP server using credentials: %s:%s:%s", this.getEndpointConfiguration().getUser(), this.getEndpointConfiguration().getPassword(), this.getEndpointConfiguration().getPrivateKeyPath()), (Throwable)e);
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void destroy() {
    }
}

