/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ftp.client;

import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpointComponent;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.ftp.client.FtpEndpointConfiguration;
import org.citrusframework.ftp.client.SftpClient;

public class SftpEndpointComponent
extends AbstractEndpointComponent {
    public SftpEndpointComponent() {
        super("sftp");
    }

    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        SftpClient ftpClient = new SftpClient();
        ftpClient.getEndpointConfiguration().setHost(this.getHost(resourcePath));
        ftpClient.getEndpointConfiguration().setPort(this.getPort(resourcePath, ftpClient.getEndpointConfiguration()));
        this.enrichEndpointConfiguration((EndpointConfiguration)ftpClient.getEndpointConfiguration(), this.getEndpointConfigurationParameters(parameters, FtpEndpointConfiguration.class), context);
        try {
            ftpClient.initialize();
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to create dynamic endpoint", (Throwable)e);
        }
        return ftpClient;
    }

    private Integer getPort(String resourcePath, FtpEndpointConfiguration endpointConfiguration) {
        if (resourcePath.contains(":")) {
            return Integer.valueOf(resourcePath.split(":")[1]);
        }
        return endpointConfiguration.getPort();
    }

    private String getHost(String resourcePath) {
        if (resourcePath.contains(":")) {
            return resourcePath.split(":")[0];
        }
        return resourcePath;
    }
}

