/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ftp.config.annotation;

import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.ftp.client.FtpClient;
import org.citrusframework.ftp.client.FtpClientBuilder;
import org.citrusframework.ftp.config.annotation.FtpClientConfig;
import org.citrusframework.message.MessageCorrelator;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;

public class FtpClientConfigParser
implements AnnotationConfigParser<FtpClientConfig, FtpClient> {
    public FtpClient parse(FtpClientConfig annotation, ReferenceResolver referenceResolver) {
        FtpClientBuilder builder = new FtpClientBuilder();
        if (StringUtils.hasText((String)annotation.host())) {
            builder.host(annotation.host());
        }
        builder.port(annotation.port());
        builder.autoReadFiles(annotation.autoReadFiles());
        builder.localPassiveMode(annotation.localPassiveMode());
        if (StringUtils.hasText((String)annotation.username())) {
            builder.username(annotation.username());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)referenceResolver.resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.errorHandlingStrategy(annotation.errorStrategy());
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (FtpClient)builder.initialize().build();
    }
}

