/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ftp.config.annotation;

import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.ftp.client.ScpClient;
import org.citrusframework.ftp.client.ScpClientBuilder;
import org.citrusframework.ftp.config.annotation.ScpClientConfig;
import org.citrusframework.message.MessageCorrelator;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;

public class ScpClientConfigParser
implements AnnotationConfigParser<ScpClientConfig, ScpClient> {
    public ScpClient parse(ScpClientConfig annotation, ReferenceResolver referenceResolver) {
        ScpClientBuilder builder = new ScpClientBuilder();
        if (StringUtils.hasText((String)annotation.host())) {
            builder.host(annotation.host());
        }
        builder.port(annotation.port());
        builder.portOption(annotation.portOption());
        if (StringUtils.hasText((String)annotation.username())) {
            builder.username(annotation.username());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.privateKeyPath())) {
            builder.privateKeyPath(annotation.privateKeyPath());
        }
        if (StringUtils.hasText((String)annotation.privateKeyPassword())) {
            builder.privateKeyPassword(annotation.privateKeyPassword());
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)referenceResolver.resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.errorHandlingStrategy(annotation.errorStrategy());
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (ScpClient)builder.initialize().build();
    }
}

