/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.ftp.message;

import java.util.List;
import java.util.Optional;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.ftpserver.ftplet.DataType;
import org.citrusframework.ftp.message.FtpMarshaller;
import org.citrusframework.ftp.model.Command;
import org.citrusframework.ftp.model.CommandResult;
import org.citrusframework.ftp.model.CommandResultType;
import org.citrusframework.ftp.model.CommandType;
import org.citrusframework.ftp.model.ConnectCommand;
import org.citrusframework.ftp.model.DeleteCommand;
import org.citrusframework.ftp.model.DeleteCommandResult;
import org.citrusframework.ftp.model.GetCommand;
import org.citrusframework.ftp.model.GetCommandResult;
import org.citrusframework.ftp.model.ListCommand;
import org.citrusframework.ftp.model.ListCommandResult;
import org.citrusframework.ftp.model.PutCommand;
import org.citrusframework.ftp.model.PutCommandResult;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.citrusframework.xml.StringResult;
import org.citrusframework.xml.StringSource;

public class FtpMessage
extends DefaultMessage {
    private static final String OPEN_COMMAND = "OPEN";
    private CommandType command;
    private CommandResultType commandResult;
    private FtpMarshaller marshaller = new FtpMarshaller();

    public FtpMessage(Message message) {
        super(message);
    }

    private FtpMessage(CommandType command) {
        super((Object)command);
        this.command = command;
        this.setCommandHeader(command);
        this.setHeader("citrus_ftp_arguments", command.getArguments());
    }

    private FtpMessage(CommandResultType commandResult) {
        super((Object)commandResult);
        this.commandResult = commandResult;
    }

    public static FtpMessage command(FTPCmd command) {
        Command cmd = new Command();
        cmd.setSignal(command.getCommand());
        return new FtpMessage(cmd);
    }

    public static FtpMessage connect(String sessionId) {
        ConnectCommand cmd = new ConnectCommand();
        cmd.setSignal(OPEN_COMMAND);
        cmd.setSessionId(sessionId);
        return new FtpMessage(cmd);
    }

    public static FtpMessage put(String localPath) {
        return FtpMessage.put(localPath, DataType.ASCII);
    }

    public static FtpMessage put(String localPath, DataType type) {
        return FtpMessage.put(localPath, FileUtils.getFileName((String)FileUtils.getFileResource((String)localPath).getLocation()), type);
    }

    public static FtpMessage put(String localPath, String remotePath, DataType type) {
        PutCommand cmd = new PutCommand();
        cmd.setSignal(FTPCmd.STOR.getCommand());
        PutCommand.File file = new PutCommand.File();
        file.setPath(localPath);
        file.setType(type.name());
        cmd.setFile(file);
        PutCommand.Target target = new PutCommand.Target();
        target.setPath(remotePath);
        cmd.setTarget(target);
        return new FtpMessage(cmd);
    }

    public static FtpMessage get(String remotePath) {
        return FtpMessage.get(remotePath, DataType.ASCII);
    }

    public static FtpMessage get(String remotePath, DataType type) {
        return FtpMessage.get(remotePath, FileUtils.getFileName((String)FileUtils.getFileResource((String)remotePath).getLocation()), type);
    }

    public static FtpMessage get(String remotePath, String localPath, DataType type) {
        GetCommand cmd = new GetCommand();
        cmd.setSignal(FTPCmd.RETR.getCommand());
        GetCommand.File file = new GetCommand.File();
        file.setPath(remotePath);
        file.setType(type.name());
        cmd.setFile(file);
        GetCommand.Target target = new GetCommand.Target();
        target.setPath(localPath);
        cmd.setTarget(target);
        return new FtpMessage(cmd);
    }

    public static FtpMessage delete(String remotePath) {
        DeleteCommand cmd = new DeleteCommand();
        cmd.setSignal(FTPCmd.DELE.getCommand());
        DeleteCommand.Target target = new DeleteCommand.Target();
        target.setPath(remotePath);
        cmd.setTarget(target);
        return new FtpMessage(cmd);
    }

    public static FtpMessage list(String remotePath) {
        ListCommand cmd = new ListCommand();
        cmd.setSignal(FTPCmd.LIST.getCommand());
        ListCommand.Target target = new ListCommand.Target();
        target.setPath(remotePath);
        cmd.setTarget(target);
        return new FtpMessage(cmd);
    }

    public static FtpMessage success() {
        CommandResult commandResult = new CommandResult();
        commandResult.setSuccess(true);
        return FtpMessage.result(commandResult);
    }

    public static FtpMessage success(int replyCode) {
        return FtpMessage.success(replyCode, "@ignore@");
    }

    public static FtpMessage success(int replyCode, String replyString) {
        return FtpMessage.result(replyCode, replyString, true);
    }

    public static FtpMessage error() {
        CommandResult commandResult = new CommandResult();
        commandResult.setSuccess(false);
        return FtpMessage.result(commandResult);
    }

    public static FtpMessage error(int replyCode) {
        return FtpMessage.success(replyCode, "@ignore@");
    }

    public static FtpMessage error(int replyCode, String replyString) {
        return FtpMessage.result(replyCode, replyString, false);
    }

    public static FtpMessage result(int replyCode, String replyString, boolean success) {
        CommandResult commandResult = new CommandResult();
        commandResult.setReplyCode(String.valueOf(replyCode));
        commandResult.setReplyString(replyString);
        commandResult.setSuccess(success);
        return FtpMessage.result(commandResult);
    }

    public static FtpMessage deleteResult(int replyCode, String replyString, boolean success) {
        DeleteCommandResult result = new DeleteCommandResult();
        result.setReplyCode(String.valueOf(replyCode));
        result.setReplyString(replyString);
        result.setSuccess(success);
        return FtpMessage.result(result);
    }

    public static FtpMessage putResult(int replyCode, String replyString, boolean success) {
        PutCommandResult result = new PutCommandResult();
        result.setReplyCode(String.valueOf(replyCode));
        result.setReplyString(replyString);
        result.setSuccess(success);
        return FtpMessage.result(result);
    }

    public static FtpMessage result(CommandResultType commandResult) {
        FtpMessage ftpMessage = new FtpMessage(commandResult);
        ftpMessage.setHeader("citrus_ftp_reply_code", commandResult.getReplyCode());
        ftpMessage.setHeader("citrus_ftp_reply_string", commandResult.getReplyString());
        return ftpMessage;
    }

    public static FtpMessage result(int replyCode, String replyString, List<String> fileNames) {
        ListCommandResult listCommandResult = new ListCommandResult();
        listCommandResult.setReplyCode(String.valueOf(replyCode));
        listCommandResult.setReplyString(replyString);
        listCommandResult.setSuccess(true);
        ListCommandResult.Files files = new ListCommandResult.Files();
        for (String fileName : fileNames) {
            ListCommandResult.Files.File file = new ListCommandResult.Files.File();
            file.setPath(fileName);
            files.getFiles().add(file);
        }
        listCommandResult.setFiles(files);
        return FtpMessage.result(listCommandResult);
    }

    public static FtpMessage result(int replyCode, String replyString, String path, String content) {
        GetCommandResult getCommandResult = new GetCommandResult();
        getCommandResult.setReplyCode(String.valueOf(replyCode));
        getCommandResult.setReplyString(replyString);
        getCommandResult.setSuccess(true);
        GetCommandResult.File file = new GetCommandResult.File();
        file.setPath(path);
        file.setData(content);
        getCommandResult.setFile(file);
        return FtpMessage.result(getCommandResult);
    }

    public FtpMessage arguments(String arguments) {
        if (this.command != null) {
            this.command.setArguments(arguments);
        }
        this.setHeader("citrus_ftp_arguments", arguments);
        return this;
    }

    public String getSignal() {
        return Optional.ofNullable(this.getHeader("citrus_ftp_command")).map(Object::toString).orElse(null);
    }

    public String getArguments() {
        return Optional.ofNullable(this.getHeader("citrus_ftp_arguments")).map(Object::toString).orElse(null);
    }

    public Integer getReplyCode() {
        Object replyCode = this.getHeader("citrus_ftp_reply_code");
        if (replyCode != null) {
            if (replyCode instanceof Integer) {
                return (Integer)replyCode;
            }
            return Integer.valueOf(replyCode.toString());
        }
        if (this.commandResult != null) {
            return Optional.ofNullable(this.commandResult.getReplyCode()).map(Integer::valueOf).orElse(200);
        }
        return null;
    }

    public boolean hasReplyCode() {
        return this.getHeader("citrus_ftp_reply_code") != null || Optional.ofNullable(this.commandResult).map(result -> StringUtils.hasText((String)result.getReplyCode())).orElse(false) != false;
    }

    public boolean hasException() {
        return Optional.ofNullable(this.commandResult).map(result -> StringUtils.hasText((String)result.getException())).orElse(false);
    }

    public String getReplyString() {
        Object replyString = this.getHeader("citrus_ftp_reply_string");
        if (replyString != null) {
            return replyString.toString();
        }
        return null;
    }

    public <T> T getPayload(Class<T> type) {
        return this.getPayload(type, this.marshaller);
    }

    public <T> T getPayload(Class<T> type, FtpMarshaller marshaller) {
        if (CommandType.class.isAssignableFrom(type)) {
            return this.getCommand(marshaller);
        }
        if (CommandResultType.class.isAssignableFrom(type)) {
            return this.getCommandResult(marshaller);
        }
        if (String.class.equals(type)) {
            return (T)this.getPayload(marshaller);
        }
        return (T)super.getPayload(type);
    }

    public Object getPayload() {
        return this.getPayload(this.marshaller);
    }

    public Object getPayload(FtpMarshaller marshaller) {
        StringResult payloadResult = new StringResult();
        if (this.command != null) {
            marshaller.marshal(this.command, (Result)payloadResult);
            return payloadResult.toString();
        }
        if (this.commandResult != null) {
            marshaller.marshal(this.commandResult, (Result)payloadResult);
            return payloadResult.toString();
        }
        return super.getPayload();
    }

    public DefaultMessage setPayload(Object payload) {
        if (payload instanceof CommandType) {
            CommandType commandType;
            this.command = commandType = (CommandType)payload;
        } else if (payload instanceof CommandResultType) {
            CommandResultType commandResultType;
            this.commandResult = commandResultType = (CommandResultType)payload;
        }
        return super.setPayload(payload);
    }

    private <T extends CommandResultType> T getCommandResult(FtpMarshaller marshaller) {
        if (this.commandResult == null) {
            Object payload = this.getPayload(marshaller);
            if (payload instanceof CommandResultType) {
                CommandResultType commandResultType;
                this.commandResult = commandResultType = (CommandResultType)payload;
            } else if (payload instanceof String) {
                String payloadString = (String)payload;
                this.commandResult = (CommandResultType)marshaller.unmarshal((Source)new StringSource(payloadString));
            }
        }
        return (T)this.commandResult;
    }

    private <T extends CommandType> T getCommand(FtpMarshaller marshaller) {
        if (this.command == null) {
            Object payload = this.getPayload(marshaller);
            if (payload instanceof CommandType) {
                CommandType commandType;
                this.command = commandType = (CommandType)payload;
            } else if (payload instanceof String) {
                String payloadString = (String)payload;
                this.command = (CommandType)marshaller.unmarshal((Source)new StringSource(payloadString));
            }
        }
        return (T)this.command;
    }

    private void setCommandHeader(CommandType command) {
        String header = command instanceof ConnectCommand ? OPEN_COMMAND : (command instanceof GetCommand ? FTPCmd.RETR.getCommand() : (command instanceof PutCommand ? FTPCmd.STOR.getCommand() : (command instanceof ListCommand ? FTPCmd.LIST.getCommand() : (command instanceof DeleteCommand ? FTPCmd.DELE.getCommand() : command.getSignal()))));
        this.setHeader("citrus_ftp_command", header);
    }

    public FtpMessage marshaller(FtpMarshaller marshaller) {
        this.marshaller = marshaller;
        return this;
    }
}

