/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.config.xml;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.citrusframework.config.xml.ActionContainerParser;
import org.citrusframework.container.AbstractSuiteActionContainer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractSuiteActionContainerParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(this.getContainerClass());
        builder.addPropertyValue("name", (Object)element.getAttribute("id"));
        if (element.hasAttribute("suites")) {
            List<String> suiteNames = Arrays.asList(element.getAttribute("suites").split(","));
            builder.addPropertyValue("suiteNames", suiteNames);
        }
        if (element.hasAttribute("groups")) {
            List<String> groups = Arrays.asList(element.getAttribute("groups").split(","));
            builder.addPropertyValue("testGroups", groups);
        }
        HashMap<String, String> envProperties = new HashMap<String, String>();
        Element envElement = DomUtils.getChildElementByTagName((Element)element, (String)"env");
        if (envElement != null) {
            List propertyElements = DomUtils.getChildElementsByTagName((Element)envElement, (String)"property");
            for (Element property : propertyElements) {
                envProperties.put(property.getAttribute("name"), property.getAttribute("value"));
            }
        }
        if (!envProperties.isEmpty()) {
            builder.addPropertyValue("env", envProperties);
        }
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        Element systemElement = DomUtils.getChildElementByTagName((Element)element, (String)"system");
        if (systemElement != null) {
            List propertyElements = DomUtils.getChildElementsByTagName((Element)systemElement, (String)"property");
            for (Element property : propertyElements) {
                systemProperties.put(property.getAttribute("name"), property.getAttribute("value"));
            }
        }
        if (!systemProperties.isEmpty()) {
            builder.addPropertyValue("systemProperties", systemProperties);
        }
        ActionContainerParser.doParse(DomUtils.getChildElementByTagName((Element)element, (String)"actions"), parserContext, builder);
        parserContext.getRegistry().registerBeanDefinition(element.getAttribute("id"), (BeanDefinition)builder.getBeanDefinition());
        return null;
    }

    protected abstract Class<? extends AbstractSuiteActionContainer> getContainerClass();
}

