/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.StartingInfo;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudDomain;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.InstanceInfo;
import org.cloudfoundry.client.lib.domain.InstanceState;
import org.cloudfoundry.client.lib.domain.InstancesInfo;
import org.cloudfoundry.maven.AbstractCloudFoundryMojo;
import org.cloudfoundry.maven.common.Assert;
import org.cloudfoundry.maven.common.CommonUtils;
import org.cloudfoundry.maven.common.DefaultConstants;
import org.cloudfoundry.maven.common.SystemProperties;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.http.HttpStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractApplicationAwareCloudFoundryMojo
extends AbstractCloudFoundryMojo {
    private static final int MAX_STATUS_CHECKS = 60;
    private String appname;
    private String url;
    private List<String> urls;
    private String artifact;
    private File path;
    private String buildpack;
    private String command;
    private Integer memory;
    private Integer instances;
    private List<CloudService> services;
    private List<String> domains;
    private Map<String, String> env = new HashMap<String, String>();
    private Boolean noStart;
    protected ArtifactRepository localRepository;
    protected List<ArtifactRepository> remoteRepositories;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;

    AbstractApplicationAwareCloudFoundryMojo() {
    }

    public String getAppname() {
        String appnameProperty = this.getCommandlineProperty(SystemProperties.APP_NAME);
        if (appnameProperty != null) {
            return appnameProperty;
        }
        if (this.appname == null) {
            return this.getArtifactId();
        }
        return this.appname;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public String getUrl() {
        String urlProperty = this.getCommandlineProperty(SystemProperties.URL);
        if (urlProperty != null) {
            return urlProperty;
        }
        if (this.url == null && this.urls == null) {
            if (this.getTarget() != null) {
                URI targetUri = this.getTarget();
                String[] tokenizedTarget = targetUri.getSchemeSpecificPart().split("\\.");
                if (tokenizedTarget.length >= 2) {
                    String domain = tokenizedTarget[tokenizedTarget.length - 2];
                    if (domain.startsWith("//")) {
                        domain = domain.substring(2);
                    }
                    return this.getAppname() + "." + domain + "." + tokenizedTarget[tokenizedTarget.length - 1];
                }
                this.getLog().warn((CharSequence)String.format("Unable to derive a suitable Url from the provided Target Url '%s'", targetUri.toString()));
                return null;
            }
            return this.getAppname() + "." + "<undefined target>";
        }
        return this.url;
    }

    protected void validatePath(File path) {
        Assert.notNull(path, "A path could not be found to deploy.  Please specify a path or artifact GAV.");
        String absolutePath = path.getAbsolutePath();
        if (!path.exists()) {
            throw new IllegalStateException(String.format("The file or directory does not exist at '%s'.", absolutePath));
        }
        if (path.isDirectory() && path.list().length == 0) {
            throw new IllegalStateException(String.format("No files found in directory '%s'.", absolutePath));
        }
    }

    public Integer getMemory() {
        String urlProperty = this.getCommandlineProperty(SystemProperties.MEMORY);
        if (urlProperty != null) {
            return Integer.valueOf(urlProperty);
        }
        if (this.memory == null) {
            return DefaultConstants.MEMORY;
        }
        return this.memory;
    }

    public File getPath() throws MojoExecutionException {
        String pathProperty = this.getCommandlineProperty(SystemProperties.PATH);
        if (pathProperty != null) {
            File path = new File(pathProperty);
            this.validatePath(path);
            return path;
        }
        if (this.path != null) {
            return this.path;
        }
        File resolvedArtifact = this.getArtifact();
        if (resolvedArtifact != null) {
            return resolvedArtifact;
        }
        return null;
    }

    private File getArtifact() throws MojoExecutionException {
        if (this.artifact != null) {
            Artifact resolvedArtifact = this.createArtifactFromGAV();
            try {
                this.artifactResolver.resolve(resolvedArtifact, this.remoteRepositories, this.localRepository);
            }
            catch (ArtifactNotFoundException ex) {
                throw new MojoExecutionException("Could not find deploy artifact [" + this.artifact + "]", (Exception)((Object)ex));
            }
            catch (ArtifactResolutionException ex) {
                throw new MojoExecutionException("Could not resolve deploy artifact [" + this.artifact + "]", (Exception)((Object)ex));
            }
            return resolvedArtifact.getFile();
        }
        return null;
    }

    Artifact createArtifactFromGAV() throws MojoExecutionException {
        String[] tokens = StringUtils.split((String)this.artifact, (String)":");
        if (tokens.length < 4 || tokens.length > 5) {
            throw new MojoExecutionException("Invalid artifact, you must specify groupId:artifactId:version:packaging[:classifier] " + this.artifact);
        }
        String groupId = tokens[0];
        String artifactId = tokens[1];
        String version = tokens[2];
        String packaging = null;
        if (tokens.length >= 4) {
            packaging = tokens[3];
        }
        String classifier = null;
        if (tokens.length == 5) {
            classifier = tokens[4];
        }
        return classifier == null ? this.artifactFactory.createBuildArtifact(groupId, artifactId, version, packaging) : this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, packaging, classifier);
    }

    public String getCommand() {
        String commandProperty = this.getCommandlineProperty(SystemProperties.COMMAND);
        if (commandProperty != null) {
            return commandProperty;
        }
        return this.command;
    }

    public String getBuildpack() {
        String buildpackProperty = this.getCommandlineProperty(SystemProperties.BUILDPACK);
        if (buildpackProperty != null) {
            return buildpackProperty;
        }
        return this.buildpack;
    }

    public Integer getInstances() {
        String instancesProperty = this.getCommandlineProperty(SystemProperties.INSTANCES);
        if (instancesProperty != null) {
            return Integer.valueOf(instancesProperty);
        }
        if (this.instances == null) {
            return DefaultConstants.DEFAULT_INSTANCE;
        }
        return this.instances;
    }

    public List<CloudService> getServices() {
        if (this.services == null) {
            return new ArrayList<CloudService>(0);
        }
        return this.services;
    }

    public List<String> getCustomDomains() {
        if (this.domains == null) {
            return new ArrayList<String>(0);
        }
        return this.domains;
    }

    public List<String> getUrls() {
        if (this.urls == null) {
            return new ArrayList<String>(0);
        }
        return this.urls;
    }

    public Boolean isNoStart() {
        String urlProperty = this.getCommandlineProperty(SystemProperties.NO_START);
        if (urlProperty != null) {
            return Boolean.valueOf(urlProperty);
        }
        if (this.noStart == null) {
            return DefaultConstants.NO_START;
        }
        return this.noStart;
    }

    public void createServices() throws MojoExecutionException {
        List currentServices = this.getClient().getServices();
        ArrayList<String> currentServicesNames = new ArrayList<String>(currentServices.size());
        for (CloudService currentService : currentServices) {
            currentServicesNames.add(currentService.getName());
        }
        for (CloudService service : this.getServices()) {
            if (currentServicesNames.contains(service.getName())) {
                this.getLog().debug((CharSequence)String.format("Service '%s' already exists", service.getName()));
                continue;
            }
            this.getLog().info((CharSequence)String.format("Creating Service '%s'", service.getName()));
            Assert.configurationServiceNotNull(service, null);
            try {
                this.client.createService(service);
            }
            catch (CloudFoundryException e) {
                throw new MojoExecutionException(String.format("Not able to create service '%s'.", service.getName()));
            }
        }
    }

    protected void uploadApplication(CloudFoundryClient client, File file, String appName) {
        boolean isDirectory = file.isDirectory();
        if (isDirectory) {
            this.getLog().debug((CharSequence)String.format("Deploying directory %s to %s.", file.getAbsolutePath(), appName));
        } else {
            this.getLog().debug((CharSequence)String.format("Deploying file %s (%s Kb) to %s.", file.getAbsolutePath(), file.length() / 1024L, appName));
        }
        try {
            client.uploadApplication(appName, file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while uploading application.", e);
        }
    }

    protected void showStagingStatus(StartingInfo startingInfo) {
        if (startingInfo != null) {
            this.responseErrorHandler.addExpectedStatus(HttpStatus.NOT_FOUND);
            int offset = 0;
            String staging = this.client.getStagingLogs(startingInfo, offset);
            while (staging != null) {
                this.getLog().info((CharSequence)staging);
                staging = this.client.getStagingLogs(startingInfo, offset += staging.length());
            }
            this.responseErrorHandler.clearExpectedStatus();
        }
    }

    protected void showStartingStatus(CloudApplication app) {
        this.getLog().info((CharSequence)String.format("Checking status of application '%s'", this.getAppname()));
        this.responseErrorHandler.addExpectedStatus(HttpStatus.BAD_REQUEST);
        int statusChecks = 0;
        while (statusChecks < 60) {
            List<InstanceInfo> instances = this.getApplicationInstances(app);
            if (instances != null) {
                int expectedInstances = this.getExpectedInstances(instances);
                int runningInstances = this.getRunningInstances(instances);
                int flappingInstances = this.getFlappingInstances(instances);
                this.showInstancesStatus(instances, runningInstances, expectedInstances);
                if (flappingInstances > 0 || runningInstances == expectedInstances) break;
            }
            ++statusChecks;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        this.responseErrorHandler.clearExpectedStatus();
    }

    protected void showInstancesStatus(List<InstanceInfo> instances, int runningInstances, int expectedInstances) {
        HashMap<String, Integer> stateCounts = new HashMap<String, Integer>();
        for (InstanceInfo instance : instances) {
            String state = instance.getState().toString();
            Integer stateCount = (Integer)stateCounts.get(state);
            if (stateCount == null) {
                stateCounts.put(state, 1);
                continue;
            }
            stateCounts.put(state, stateCount + 1);
        }
        ArrayList<String> stateStrings = new ArrayList<String>();
        for (Map.Entry stateCount : stateCounts.entrySet()) {
            stateStrings.add(String.format("%s %s", stateCount.getValue(), ((String)stateCount.getKey()).toLowerCase()));
        }
        this.getLog().info((CharSequence)String.format("  %d of %d instances running (%s)", runningInstances, expectedInstances, CommonUtils.collectionToCommaDelimitedString(stateStrings)));
    }

    protected void showStartResults(CloudApplication app, List<String> uris) throws MojoExecutionException {
        List<InstanceInfo> instances = this.getApplicationInstances(app);
        int expectedInstances = this.getExpectedInstances(instances);
        int runningInstances = this.getRunningInstances(instances);
        int flappingInstances = this.getFlappingInstances(instances);
        if (flappingInstances > 0 || runningInstances == 0) {
            throw new MojoExecutionException("Application start unsuccessful");
        }
        if (runningInstances > 0) {
            if (uris.isEmpty()) {
                this.getLog().info((CharSequence)String.format("Application '%s' is available", app.getName()));
            } else {
                this.getLog().info((CharSequence)String.format("Application '%s' is available at '%s'", app.getName(), CommonUtils.collectionToCommaDelimitedString(uris, "http://")));
            }
        }
    }

    protected void addDomains() {
        List domains = this.getClient().getDomains();
        ArrayList<String> currentDomains = new ArrayList<String>(domains.size());
        for (CloudDomain cloudDomain : domains) {
            currentDomains.add(cloudDomain.getName());
        }
        for (String string : this.getCustomDomains()) {
            if (currentDomains.contains(string)) continue;
            this.getClient().addDomain(string);
        }
    }

    private List<InstanceInfo> getApplicationInstances(CloudApplication app) {
        InstancesInfo instancesInfo = this.client.getApplicationInstances(app);
        if (instancesInfo != null) {
            return instancesInfo.getInstances();
        }
        return null;
    }

    private int getExpectedInstances(List<InstanceInfo> instances) {
        return instances == null ? 0 : instances.size();
    }

    private int getRunningInstances(List<InstanceInfo> instances) {
        return this.getInstanceCount(instances, InstanceState.RUNNING);
    }

    private int getFlappingInstances(List<InstanceInfo> instances) {
        return this.getInstanceCount(instances, InstanceState.FLAPPING);
    }

    private int getInstanceCount(List<InstanceInfo> instances, InstanceState state) {
        int count = 0;
        if (instances != null) {
            for (InstanceInfo instance : instances) {
                if (!instance.getState().equals((Object)state)) continue;
                ++count;
            }
        }
        return count;
    }

    protected List<String> getAllUris() throws MojoExecutionException {
        ArrayList<String> uris = new ArrayList<String>(0);
        Assert.configurationUrls(this.getUrl(), this.getUrls());
        if (this.getUrl() != null) {
            uris.add(this.getUrl());
        } else if (!this.getUrls().isEmpty()) {
            for (String uri : this.getUrls()) {
                uris.add(uri);
            }
        }
        return uris;
    }
}

