/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.tokens.TokensFile;
import org.cloudfoundry.maven.common.Assert;
import org.cloudfoundry.maven.common.SystemProperties;
import org.cloudfoundry.maven.common.WarningBypassingResponseErrorHandler;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;

public abstract class AbstractCloudFoundryMojo
extends AbstractMojo {
    private String artifactId;
    protected CloudFoundryClient client;
    protected TokensFile tokensFile = new TokensFile();
    protected WarningBypassingResponseErrorHandler responseErrorHandler = new WarningBypassingResponseErrorHandler();
    protected String password;
    private String server;
    private MavenSession session;
    private String target;
    protected String username;
    private String org;
    private String space;
    private boolean skip;
    private WagonManager wagonManager;

    public AbstractCloudFoundryMojo() {
    }

    public AbstractCloudFoundryMojo(TokensFile tokensFile) {
        this.tokensFile = tokensFile;
    }

    protected OAuth2AccessToken retrieveToken() throws MojoExecutionException {
        OAuth2AccessToken token = this.tokensFile.retrieveToken(this.getTarget());
        if (token == null) {
            throw new MojoExecutionException(String.format("Can not authenticate to target '%s'. Configure a username and password, or use the login goal.", this.getTarget().toString()));
        }
        return token;
    }

    protected CloudFoundryClient createCloudFoundryClient(OAuth2AccessToken token, URI target, String org, String space) throws MojoExecutionException {
        Assert.configurationNotNull(org, "org", SystemProperties.ORG);
        Assert.configurationNotNull(space, "space", SystemProperties.SPACE);
        this.getLog().debug((CharSequence)String.format("Connecting to Cloud Foundry at '%s' using token", target.toString()));
        try {
            CloudCredentials credentials = new CloudCredentials(token);
            CloudFoundryClient client = new CloudFoundryClient(credentials, target.toURL(), org, space);
            client.setResponseErrorHandler((ResponseErrorHandler)this.responseErrorHandler);
            return client;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(String.format("Incorrect Cloud Foundry target URL '%s'. Make sure the URL contains a scheme, e.g. http://...", target), (Exception)e);
        }
    }

    protected CloudFoundryClient createCloudFoundryClient(String username, String password, URI target, String org, String space) throws MojoExecutionException {
        Assert.configurationNotNull(username, "username", SystemProperties.USERNAME);
        Assert.configurationNotNull(password, "password", SystemProperties.PASSWORD);
        Assert.configurationNotNull(org, "org", SystemProperties.ORG);
        Assert.configurationNotNull(space, "space", SystemProperties.SPACE);
        this.getLog().debug((CharSequence)String.format("Connecting to Cloud Foundry at '%s' with username: '%s'", target, username));
        try {
            CloudCredentials credentials = new CloudCredentials(username, password);
            CloudFoundryClient client = new CloudFoundryClient(credentials, target.toURL(), org, space);
            this.connectToCloudFoundry(client);
            client.setResponseErrorHandler((ResponseErrorHandler)this.responseErrorHandler);
            return client;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(String.format("Incorrect Cloud Foundry target URL '%s'. Make sure the URL contains a scheme, e.g. http://...", target), (Exception)e);
        }
    }

    protected void connectToCloudFoundry(CloudFoundryClient client) throws MojoExecutionException {
        try {
            client.login();
        }
        catch (CloudFoundryException e) {
            if (HttpStatus.FORBIDDEN.equals((Object)e.getStatusCode())) {
                throw new MojoExecutionException(String.format("Login failed to '%s' using username '%s'. Please verify your login credentials.", this.target, this.username), (Exception)((Object)e));
            }
            if (HttpStatus.NOT_FOUND.equals((Object)e.getStatusCode())) {
                throw new MojoExecutionException(String.format("The target host '%s' exists but it does not appear to be a valid Cloud Foundry target url.", this.target), (Exception)((Object)e));
            }
            throw e;
        }
        catch (ResourceAccessException e) {
            throw new MojoExecutionException(String.format("Cannot access host at '%s'.", this.target), (Exception)((Object)e));
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of Cloud Foundry Maven Plugin");
            return;
        }
        Assert.configurationNotNull(this.target, "target", SystemProperties.TARGET);
        try {
            this.client = this.getUsername() != null && this.getPassword() != null ? this.createCloudFoundryClient(this.getUsername(), this.getPassword(), this.getTarget(), this.getOrg(), this.getSpace()) : this.createCloudFoundryClient(this.retrieveToken(), this.getTarget(), this.getOrg(), this.getSpace());
            this.doExecute();
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("An exception was caught while executing Mojo.", (Exception)e);
        }
    }

    public String getArtifactId() {
        Assert.notNull(this.artifactId, "The artifactId is not set.");
        return this.artifactId;
    }

    public CloudFoundryClient getClient() {
        return this.client;
    }

    public String getCommandlineProperty(SystemProperties property) {
        return this.session.getExecutionProperties().getProperty(property.getProperty());
    }

    public String getPassword() {
        String passwordProperty = this.getCommandlineProperty(SystemProperties.PASSWORD);
        if (passwordProperty != null) {
            return passwordProperty;
        }
        if (this.password == null) {
            this.getLog().debug((CharSequence)("No password defined in pom.xml and no system property defined either. Trying to look up password in settings.xml under server element " + this.getServer()));
            AuthenticationInfo authenticationInfo = this.wagonManager.getAuthenticationInfo(this.getServer());
            if (authenticationInfo == null) {
                this.getLog().debug((CharSequence)String.format("In settings.xml server element '%s' was not defined.", this.getServer()));
                return null;
            }
            if (authenticationInfo.getPassword() != null) {
                return authenticationInfo.getPassword();
            }
            this.getLog().debug((CharSequence)String.format("In settings.xml no password was found for server element '%s'. Does the element exist?", this.getServer()));
            return null;
        }
        return this.password;
    }

    public String getServer() {
        String serverProperty = this.getCommandlineProperty(SystemProperties.SETTINGS_SERVER);
        if (serverProperty != null) {
            return serverProperty;
        }
        if (this.server == null) {
            return "cloud-foundry-credentials";
        }
        return this.server;
    }

    public URI getTarget() {
        String targetProperty = this.getCommandlineProperty(SystemProperties.TARGET);
        if (targetProperty != null) {
            try {
                URI uri = new URI(targetProperty);
                if (uri.isAbsolute()) {
                    return uri;
                }
                throw new URISyntaxException(targetProperty, "URI is not opaque.");
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(String.format("The Url parameter '%s' which was passed in as system property is not valid.", targetProperty));
            }
        }
        if (this.target == null) {
            return null;
        }
        try {
            return new URI(this.target);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(String.format("The Url parameter '%s' which was passed in as pom.xml configiuration parameter is not valid.", this.target));
        }
    }

    public String getUsername() {
        String usernameProperty = this.getCommandlineProperty(SystemProperties.USERNAME);
        if (usernameProperty != null) {
            return usernameProperty;
        }
        if (this.username == null) {
            this.getLog().debug((CharSequence)("No username defined in pom.xml and no system property defined either. Trying to look up username in settings.xml under server element " + this.getServer()));
            AuthenticationInfo authenticationInfo = this.wagonManager.getAuthenticationInfo(this.getServer());
            if (authenticationInfo == null) {
                this.getLog().debug((CharSequence)String.format("In settings.xml server element '%s' was not defined.", this.getServer()));
                return null;
            }
            if (authenticationInfo.getUserName() != null) {
                return authenticationInfo.getUserName();
            }
            super.getLog().debug((CharSequence)String.format("In settings.xml no username was found for server element '%s'. Does the element exist?", this.getServer()));
            return null;
        }
        return this.username;
    }

    public String getOrg() {
        Assert.notNull(this.org, "The org is not set.");
        return this.org;
    }

    public String getSpace() {
        Assert.notNull(this.space, "The space is not set.");
        return this.space;
    }
}

