/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.StartingInfo;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.Staging;
import org.cloudfoundry.maven.AbstractApplicationAwareCloudFoundryMojo;
import org.cloudfoundry.maven.common.CommonUtils;
import org.springframework.http.HttpStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPush
extends AbstractApplicationAwareCloudFoundryMojo {
    @Override
    protected void doExecute() throws MojoExecutionException {
        String appname = this.getAppname();
        String command = this.getCommand();
        String buildpack = this.getBuildpack();
        Map env = this.getEnv();
        Integer instances = this.getInstances();
        Integer memory = this.getMemory();
        File path = this.getPath();
        List<String> uris = this.getAllUris();
        List<String> serviceNames = this.getServiceNames();
        this.validateMemoryChoice(this.getClient(), memory);
        this.validatePath(path);
        this.addDomains();
        this.createServices();
        this.getLog().debug((CharSequence)String.format("Pushing App - Appname: %s, Command: %s, Env: %s, Instances: %s, Memory: %s, Path: %s, Services: %s, Uris: %s,", appname, command, env, instances, memory, path, serviceNames, uris));
        this.getLog().info((CharSequence)String.format("Creating application '%s'", appname));
        this.createApplication(appname, command, buildpack, memory, uris, serviceNames);
        this.getLog().debug((CharSequence)"Updating application env...");
        try {
            this.getClient().updateApplicationEnv(appname, env);
        }
        catch (CloudFoundryException e) {
            throw new MojoExecutionException(String.format("Error while updating application env '%s'. Error message: '%s'. Description: '%s'", this.getAppname(), e.getMessage(), e.getDescription()), (Exception)((Object)e));
        }
        this.getLog().info((CharSequence)String.format("Uploading '%s'", path));
        try {
            this.uploadApplication(this.getClient(), path, appname);
        }
        catch (CloudFoundryException e) {
            throw new MojoExecutionException(String.format("Error while creating application '%s'. Error message: '%s'. Description: '%s'", this.getAppname(), e.getMessage(), e.getDescription()), (Exception)((Object)e));
        }
        if (instances != null) {
            this.getLog().debug((CharSequence)("Setting the number of instances to " + instances));
            try {
                this.getClient().updateApplicationInstances(appname, instances.intValue());
            }
            catch (CloudFoundryException e) {
                throw new MojoExecutionException(String.format("Error while setting number of instances for application '%s'. Error message: '%s'. Description: '%s'", this.getAppname(), e.getMessage(), e.getDescription()), (Exception)((Object)e));
            }
        }
        if (!this.isNoStart().booleanValue()) {
            this.getLog().info((CharSequence)"Starting application");
            try {
                StartingInfo startingInfo = this.getClient().startApplication(appname);
                this.showStagingStatus(startingInfo);
                CloudApplication app = this.getClient().getApplication(appname);
                this.showStartingStatus(app);
                this.showStartResults(app, uris);
            }
            catch (CloudFoundryException e) {
                throw new MojoExecutionException(String.format("Error while creating application '%s'. Error message: '%s'. Description: '%s'", this.getAppname(), e.getMessage(), e.getDescription()), (Exception)((Object)e));
            }
        }
    }

    private void createApplication(String appname, String command, String buildpack, Integer memory, List<String> uris, List<String> serviceNames) throws MojoExecutionException {
        boolean found;
        try {
            this.getClient().getApplication(appname);
            found = true;
        }
        catch (CloudFoundryException e) {
            if (HttpStatus.NOT_FOUND.equals((Object)e.getStatusCode())) {
                found = false;
            }
            throw new MojoExecutionException(String.format("Error while checking for existing application '%s'. Error message: '%s'. Description: '%s'", appname, e.getMessage(), e.getDescription()), (Exception)((Object)e));
        }
        try {
            Staging staging = new Staging(command, buildpack);
            if (!found) {
                this.getClient().createApplication(appname, staging, memory.intValue(), uris, serviceNames);
            } else {
                this.client.stopApplication(appname);
                this.client.updateApplicationStaging(appname, staging);
                this.client.updateApplicationMemory(appname, memory.intValue());
                this.client.updateApplicationUris(appname, uris);
                this.client.updateApplicationServices(appname, serviceNames);
            }
        }
        catch (CloudFoundryException e) {
            throw new MojoExecutionException(String.format("Error while creating application '%s'. Error message: '%s'. Description: '%s'", this.getAppname(), e.getMessage(), e.getDescription()), (Exception)((Object)e));
        }
    }

    private List<String> getServiceNames() {
        List services = this.getServices();
        ArrayList<String> serviceNames = new ArrayList<String>();
        for (CloudService service : services) {
            serviceNames.add(service.getName());
        }
        return serviceNames;
    }

    protected void validateMemoryChoice(CloudFoundryClient cloudFoundryClient, Integer desiredMemory) {
        int[] memoryChoices = cloudFoundryClient.getApplicationMemoryChoices();
        this.validateMemoryChoice(memoryChoices, desiredMemory);
    }

    protected void validateMemoryChoice(int[] availableMemoryChoices, Integer desiredMemory) {
        boolean match = false;
        ArrayList<String> memoryChoicesAsString = new ArrayList<String>();
        for (int i : availableMemoryChoices) {
            if (Integer.valueOf(i).equals(desiredMemory)) {
                match = true;
            }
            memoryChoicesAsString.add(String.valueOf(i));
        }
        if (!match) {
            throw new IllegalStateException("Memory must be one of the following values: " + CommonUtils.collectionToCommaDelimitedString(memoryChoicesAsString));
        }
    }
}

