/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.cloudfoundry.maven.AbstractApplicationAwareCloudFoundryMojo;
import org.cloudfoundry.maven.common.Assert;
import org.cloudfoundry.maven.common.CommonUtils;
import org.cloudfoundry.maven.common.SystemProperties;
import org.cloudfoundry.maven.common.UiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Help
extends AbstractApplicationAwareCloudFoundryMojo {
    public static final String HELP_TEXT = "/help.txt";
    public static final String NOT_AVAILABLE = "N/A";

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.doExecute();
    }

    private Map<String, String> getParameterMap() throws MojoExecutionException {
        TreeMap<String, String> parameterMap = new TreeMap<String, String>();
        parameterMap.put("Appname", this.getAppname() != null ? this.getAppname() : NOT_AVAILABLE);
        parameterMap.put("Command", this.getCommand() != null ? this.getCommand() : NOT_AVAILABLE);
        parameterMap.put("Instances", this.getInstances() != null ? String.valueOf(this.getInstances()) : NOT_AVAILABLE);
        parameterMap.put("Memory (in MB)", this.getMemory() != null ? String.valueOf(this.getMemory()) : NOT_AVAILABLE);
        parameterMap.put("Org", this.getOrg() != null ? this.getOrg() : NOT_AVAILABLE);
        parameterMap.put("Env", this.getEnv() != null ? String.valueOf(this.getEnv()) : NOT_AVAILABLE);
        parameterMap.put("No-start", this.isNoStart() != null ? String.valueOf(this.isNoStart()) : NOT_AVAILABLE);
        parameterMap.put("Password", this.getPassword() != null ? CommonUtils.maskPassword(this.getPassword()) : NOT_AVAILABLE);
        parameterMap.put("Server", this.getServer());
        parameterMap.put("Services", this.getServices().isEmpty() ? NOT_AVAILABLE : CommonUtils.collectionServicesToCommaDelimitedString(this.getServices()));
        parameterMap.put("Space", this.getSpace() != null ? this.getSpace() : NOT_AVAILABLE);
        parameterMap.put("Target", this.getTarget() != null ? this.getTarget().toString() : NOT_AVAILABLE);
        parameterMap.put("Url", this.getUrl() != null ? this.getUrl() : NOT_AVAILABLE);
        parameterMap.put("Username", this.getUsername() != null ? this.getUsername() : NOT_AVAILABLE);
        parameterMap.put("Path", this.getPath() != null ? this.getPath().getAbsolutePath() : NOT_AVAILABLE);
        return parameterMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws MojoExecutionException {
        Assert.configurationNotNull(this.getTarget(), "target", SystemProperties.TARGET);
        StringBuilder sb = new StringBuilder();
        sb.append("\n-------------------------------------------------------------------------------\n");
        sb.append("\nCloud Foundry Maven Plugin detected parameters and/or default values:\n\n");
        sb.append(UiUtils.renderParameterInfoDataAsTable(this.getParameterMap()));
        InputStreamReader reader = null;
        BufferedReader in = null;
        try {
            InputStream is = Help.class.getResourceAsStream(HELP_TEXT);
            reader = new InputStreamReader(is);
            in = new BufferedReader(reader);
            StringBuilder helpTextStringBuilder = new StringBuilder();
            String line = "";
            while (line != null) {
                try {
                    line = in.readLine();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Problem reading internal '/help.txt' file. This is a bug.", e);
                }
                if (line == null) continue;
                helpTextStringBuilder.append(line + "\n");
            }
            sb.append((CharSequence)helpTextStringBuilder);
        }
        catch (Throwable throwable) {
            CommonUtils.closeReader(in);
            CommonUtils.closeReader(reader);
            throw throwable;
        }
        CommonUtils.closeReader(in);
        CommonUtils.closeReader(reader);
        this.getLog().info((CharSequence)sb);
    }
}

