/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.cloudfoundry.client.lib.domain.CloudInfo;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.cloudfoundry.client.lib.tokens.TokensFile;
import org.cloudfoundry.maven.AbstractCloudFoundryMojo;
import org.cloudfoundry.maven.common.Assert;
import org.cloudfoundry.maven.common.SystemProperties;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class Login
extends AbstractCloudFoundryMojo {
    public Login() {
    }

    public Login(TokensFile tokensFile) {
        this.tokensFile = tokensFile;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Assert.configurationNotNull(this.getUsername(), "username", SystemProperties.USERNAME);
        Assert.configurationNotNull(this.getPassword(), "password", SystemProperties.PASSWORD);
        Assert.configurationNotNull(this.getTarget(), "target", SystemProperties.TARGET);
        super.execute();
    }

    protected void doExecute() throws MojoExecutionException {
        OAuth2AccessToken token = this.getClient().login();
        CloudInfo cloudInfo = this.getClient().getCloudInfo();
        CloudSpace space = this.getCurrentSpace();
        this.tokensFile.saveToken(this.getTarget(), token, cloudInfo, space);
        this.getLog().info((CharSequence)"Authentication successful");
    }

    protected CloudSpace getCurrentSpace() {
        List spaces = this.client.getSpaces();
        for (CloudSpace space : spaces) {
            if (!space.getName().equals(this.getSpace())) continue;
            return space;
        }
        return null;
    }
}

