/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven;

import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.maven.AbstractApplicationAwareCloudFoundryMojo;
import org.springframework.http.HttpStatus;

public class Logs
extends AbstractApplicationAwareCloudFoundryMojo {
    protected void doExecute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)String.format("Getting logs for '%s'", this.getAppname()));
            Map logs = this.getClient().getLogs(this.getAppname());
            for (Map.Entry entry : logs.entrySet()) {
                this.getLog().info((CharSequence)String.format("Reading '%s'\n%s", entry.getKey(), entry.getValue()));
            }
        }
        catch (CloudFoundryException e) {
            if (HttpStatus.NOT_FOUND.equals((Object)e.getStatusCode())) {
                throw new MojoExecutionException(String.format("Application '%s' does not exist", this.getAppname()), (Exception)((Object)e));
            }
            throw new MojoExecutionException(String.format("Error getting logs for application '%s'. Error message: '%s'. Description: '%s'", this.getAppname(), e.getMessage(), e.getDescription()), (Exception)((Object)e));
        }
    }
}

