/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.maven.AbstractApplicationAwareCloudFoundryMojo;
import org.cloudfoundry.maven.common.Assert;
import org.cloudfoundry.maven.common.SystemProperties;

public class Scale
extends AbstractApplicationAwareCloudFoundryMojo {
    protected void doExecute() throws MojoExecutionException {
        Integer instances = this.getInstances();
        String appname = this.getAppname();
        Assert.configurationNotNull(instances, "instances", SystemProperties.INSTANCES);
        this.getLog().info((CharSequence)String.format("Setting number of instances for application '%s' to '%s'", appname, instances));
        try {
            this.getClient().updateApplicationInstances(appname, instances.intValue());
        }
        catch (CloudFoundryException e) {
            throw new MojoExecutionException(String.format("Error setting  number of instances for application '%s'. Error message: '%s'. Description: '%s'", this.getAppname(), e.getMessage(), e.getDescription()), (Exception)((Object)e));
        }
    }
}

