/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.maven.AbstractCloudFoundryMojo;
import org.cloudfoundry.maven.common.UiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Services
extends AbstractCloudFoundryMojo {
    @Override
    protected void doExecute() {
        List services = this.getClient().getServices();
        List apps = this.getClient().getApplications();
        Map<String, List<String>> servicesToApps = this.mapServicesToApps(services, apps);
        this.getLog().info((CharSequence)"Services instances");
        this.getLog().info((CharSequence)("\n" + UiUtils.renderServiceDataAsTable(services, servicesToApps)));
    }

    protected Map<String, List<String>> mapServicesToApps(List<CloudService> services, List<CloudApplication> apps) {
        HashMap<String, List<String>> servicesToApps = new HashMap<String, List<String>>(services.size());
        for (CloudApplication app : apps) {
            for (String serviceName : app.getServices()) {
                ArrayList<String> appNames = (ArrayList<String>)servicesToApps.get(serviceName);
                if (appNames == null) {
                    appNames = new ArrayList<String>();
                }
                appNames.add(app.getName());
                servicesToApps.put(serviceName, appNames);
            }
        }
        return servicesToApps;
    }
}

