/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven;

import java.net.MalformedURLException;
import java.net.URI;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.domain.CloudInfo;
import org.cloudfoundry.maven.AbstractCloudFoundryMojo;
import org.cloudfoundry.maven.common.Assert;
import org.cloudfoundry.maven.common.SystemProperties;
import org.cloudfoundry.maven.common.UiUtils;

public class Target
extends AbstractCloudFoundryMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        URI target = this.getTarget();
        Assert.configurationNotNull(target, "target", SystemProperties.TARGET);
        try {
            this.client = new CloudFoundryClient(this.getTarget().toURL());
            this.doExecute();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(String.format("Incorrect Cloud Foundry target url, are you sure '%s' is correct? Make sure the url contains a scheme, e.g. http://... ", target), (Exception)e);
        }
    }

    protected void doExecute() throws MojoExecutionException {
        CloudFoundryClient newClient = this.getUsername() != null && this.getPassword() != null ? this.createCloudFoundryClient(this.getUsername(), this.getPassword(), this.getTarget(), this.getOrg(), this.getSpace()) : this.createCloudFoundryClient(this.retrieveToken(), this.getTarget(), this.getOrg(), this.getSpace());
        CloudInfo cloudInfo = newClient.getCloudInfo();
        this.getLog().info((CharSequence)UiUtils.renderCloudInfoFormattedAsString(cloudInfo, this.getTarget().toString(), this.getOrg(), this.getSpace()));
    }
}

