/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.maven.AbstractApplicationAwareCloudFoundryMojo;

public class UnbindServices
extends AbstractApplicationAwareCloudFoundryMojo {
    protected void doExecute() throws MojoExecutionException {
        for (CloudService service : this.getServices()) {
            if (this.getClient().getService(service.getName()) == null) {
                throw new MojoExecutionException(String.format("Service '%s' does not exist", service.getName()));
            }
            try {
                CloudApplication application = this.getClient().getApplication(this.getAppname());
                if (application.getServices().contains(service.getName())) {
                    this.getLog().info((CharSequence)String.format("Unbinding Service '%s'", service.getName()));
                    this.getClient().unbindService(this.getAppname(), service.getName());
                    continue;
                }
                this.getLog().info((CharSequence)String.format("Service '%s' is not bound to application '%s'", service.getName(), application.getName()));
            }
            catch (CloudFoundryException e) {
                throw new MojoExecutionException(String.format("Application '%s' does not exist", this.getAppname()));
            }
        }
    }
}

