/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven.common;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.maven.common.SystemProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Assert {
    private Assert() {
        throw new AssertionError();
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void configurationNotNull(Object object, String objectName, SystemProperties property) throws MojoExecutionException {
        Assert.configurationNotNull(object, objectName, property, null);
    }

    public static void configurationNotNull(Object object, String objectName, SystemProperties property, String additionalDescription) throws MojoExecutionException {
        if (object == null) {
            StringBuilder message = new StringBuilder("\n\n");
            message.append("-------------------------------------------------------------------------------\n");
            message.append(String.format("\nRequired argument '%s' is missing.\n", objectName));
            message.append("========================================================================\n\n");
            message.append(String.format("Did you configure the parameter? You can provide the parameter either as:\n\n- System Property using: -D%1$s=<provide value> or \n- Add the parameter to the pom.xml under the plugin's configuration element:\n\n    <configuration>\n        <%2$s>provide value</%2$s>\n    </configuration>\n\n", property.getProperty(), property.getXmlElement()));
            message.append("-------------------------------------------------------------------------------\n");
            if (additionalDescription != null) {
                message.append(additionalDescription + "\n");
                message.append("-------------------------------------------------------------------------------\n");
            }
            throw new MojoExecutionException(message.toString());
        }
    }

    public static void configurationServiceNotNull(CloudService cloudService, String additionalDescription) throws MojoExecutionException {
        if (cloudService.getName() == null || cloudService.getLabel() == null) {
            StringBuilder message = new StringBuilder("\n\n");
            message.append("-------------------------------------------------------------------------------\n");
            message.append(String.format("\nRequired arguments for '%s' are missing.\n", cloudService.getName()));
            message.append("========================================================================\n\n");
            message.append("Did you configure the parameter? You ");
            message.append("can provide the parameter in the pom.xml under the plugin's configuration element:\n\n");
            message.append("<configuration>\n");
            message.append("  <services>\n");
            message.append("    <service>\n");
            message.append("      <name>provide value</name>\n");
            message.append("      <label>provide value</label>\n");
            message.append("    <service>\n");
            message.append("  <services>\n");
            message.append("</configuration>\n\n");
            message.append("-------------------------------------------------------------------------------\n");
            if (additionalDescription != null) {
                message.append(additionalDescription + "\n");
                message.append("-------------------------------------------------------------------------------\n");
            }
            throw new MojoExecutionException(message.toString());
        }
    }

    public static void configurationUrls(String url, List<String> urls) throws MojoExecutionException {
        if (url != null && !urls.isEmpty()) {
            StringBuilder message = new StringBuilder("\n\n");
            message.append("Both url and urls elements are specified at the same level\n");
            message.append("========================================================================\n\n");
            message.append("The element <url> should be nested inside a <urls> element or specified alone without a <urls> element present.\n");
            message.append("-------------------------------------------------------------------------------\n");
            throw new MojoExecutionException(message.toString());
        }
    }
}

