/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven.common;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.CloudServiceOffering;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonUtils {
    private CommonUtils() {
        throw new AssertionError();
    }

    public static String padRight(String string, int size, char paddingChar) {
        if (string == null) {
            return "";
        }
        StringBuilder padded = new StringBuilder(string);
        while (padded.length() < size) {
            padded.append(paddingChar);
        }
        return padded.toString();
    }

    public static String padRight(String string, int size) {
        return CommonUtils.padRight(string, size, ' ');
    }

    public static String collectionToCommaDelimitedString(Collection<String> list) {
        return StringUtils.collectionToDelimitedString(list, (String)", ");
    }

    public static String collectionToCommaDelimitedString(Collection<String> list, String prefix) {
        return StringUtils.collectionToDelimitedString(list, (String)", ", (String)prefix, (String)"");
    }

    public static String collectionServicesToCommaDelimitedString(Collection<CloudService> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        ArrayList<String> sb = new ArrayList<String>();
        for (CloudService service : list) {
            sb.add(service.getName());
        }
        return ((Object)sb).toString();
    }

    public static void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Encountered problem closing Reader.", e);
            }
        }
    }

    public static boolean isValidEmail(String emailAddress) {
        String regex = "^[_A-Za-z0-9-+]+(\\.[_A-Za-z0-9-+]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$";
        return emailAddress.matches("^[_A-Za-z0-9-+]+(\\.[_A-Za-z0-9-+]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$");
    }

    public static String maskPassword(String password) {
        int lengthOfPassword = password.length();
        StringBuilder stringBuilder = new StringBuilder(lengthOfPassword);
        for (int i = 0; i < lengthOfPassword; ++i) {
            stringBuilder.append('*');
        }
        return stringBuilder.toString();
    }

    public static String serviceOfferingsToCommaDelimitedString(Collection<CloudServiceOffering> offerings) {
        if (offerings == null || offerings.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<CloudServiceOffering> it = offerings.iterator();
        while (it.hasNext()) {
            CloudServiceOffering offering = it.next();
            sb.append(offering.getLabel());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

