/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.maven.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudInfo;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.CloudServiceOffering;
import org.cloudfoundry.client.lib.domain.CloudServicePlan;
import org.cloudfoundry.maven.common.CommonUtils;
import org.cloudfoundry.maven.common.Table;
import org.cloudfoundry.maven.common.TableHeader;
import org.cloudfoundry.maven.common.TableRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UiUtils {
    public static final String HORIZONTAL_LINE = "-------------------------------------------------------------------------------\n";
    public static final int COLUMN_1 = 1;
    public static final int COLUMN_2 = 2;
    public static final int COLUMN_3 = 3;
    public static final int COLUMN_4 = 4;
    public static final int COLUMN_5 = 5;
    public static final int COLUMN_6 = 6;

    private UiUtils() {
        throw new AssertionError();
    }

    public static String renderCloudApplicationDataAsTable(CloudApplication application) {
        StringBuilder sb = new StringBuilder("\n");
        sb.append(String.format("%s: %s\n", application.getName(), application.getState()));
        sb.append(String.format("  usage: %sM x %s instance\n", application.getMemory(), application.getInstances()));
        sb.append(String.format("  urls: %s\n", CommonUtils.collectionToCommaDelimitedString(application.getUris())));
        sb.append(String.format("  services: %s\n", CommonUtils.collectionToCommaDelimitedString(application.getServices())));
        return sb.toString();
    }

    public static String renderCloudApplicationsDataAsTable(List<CloudApplication> applications) {
        Table table = new Table();
        table.getHeaders().put(1, new TableHeader("name"));
        table.getHeaders().put(2, new TableHeader("status"));
        table.getHeaders().put(3, new TableHeader("usage"));
        table.getHeaders().put(4, new TableHeader("url"));
        Comparator<CloudApplication> nameComparator = new Comparator<CloudApplication>(){

            @Override
            public int compare(CloudApplication a, CloudApplication b) {
                return a.getName().compareTo(b.getName());
            }
        };
        Collections.sort(applications, nameComparator);
        for (CloudApplication application : applications) {
            TableRow tableRow = new TableRow();
            table.getHeaders().get(1).updateWidth(application.getName().length());
            tableRow.addValue(1, application.getName());
            String status = UiUtils.renderHealthStatus(application);
            table.getHeaders().get(2).updateWidth(status.length());
            tableRow.addValue(2, status);
            String usage = String.format("%d x %dM", application.getInstances(), application.getMemory());
            table.getHeaders().get(3).updateWidth(String.valueOf(usage).length());
            tableRow.addValue(3, String.valueOf(usage));
            String uris = CommonUtils.collectionToCommaDelimitedString(application.getUris());
            table.getHeaders().get(4).updateWidth(uris.length());
            tableRow.addValue(4, uris);
            table.getRows().add(tableRow);
        }
        return UiUtils.renderTextTable(table);
    }

    private static String renderHealthStatus(CloudApplication app) {
        String state = app.getState().toString();
        if (state.equals("STARTED")) {
            int running_instances = app.getRunningInstances();
            int expected_instances = app.getInstances();
            if (expected_instances > 0) {
                float ratio = running_instances / expected_instances;
                if ((double)ratio == 1.0) {
                    return "running";
                }
                return new Float(ratio * 100.0f).intValue() + "%";
            }
            return "n/a";
        }
        return state.toLowerCase();
    }

    public static String renderEnvVarDataAsTable(CloudApplication application) {
        StringBuilder sb = new StringBuilder("\n");
        sb.append(String.format("Environment for application '%s'\n", application.getName()));
        List envVars = application.getEnv();
        for (String envVar : envVars) {
            sb.append(envVar).append("\n");
        }
        return sb.toString();
    }

    public static String renderServiceOfferingDataAsTable(List<CloudServiceOffering> serviceOfferings) {
        Comparator<CloudServiceOffering> labelComparator = new Comparator<CloudServiceOffering>(){

            @Override
            public int compare(CloudServiceOffering a, CloudServiceOffering b) {
                return a.getLabel().compareTo(b.getLabel());
            }
        };
        Collections.sort(serviceOfferings, labelComparator);
        Table table = new Table();
        table.getHeaders().put(1, new TableHeader("service"));
        table.getHeaders().put(2, new TableHeader("version"));
        table.getHeaders().put(3, new TableHeader("provider"));
        table.getHeaders().put(4, new TableHeader("plans"));
        table.getHeaders().put(5, new TableHeader("description"));
        for (CloudServiceOffering serviceOffering : serviceOfferings) {
            TableRow tableRow = new TableRow();
            table.getHeaders().get(1).updateWidth(serviceOffering.getLabel().length());
            tableRow.addValue(1, serviceOffering.getLabel());
            table.getHeaders().get(2).updateWidth(serviceOffering.getVersion().length());
            tableRow.addValue(2, serviceOffering.getVersion());
            table.getHeaders().get(3).updateWidth(serviceOffering.getProvider().length());
            tableRow.addValue(3, serviceOffering.getProvider());
            ArrayList<String> CloudServicePlanNames = new ArrayList<String>();
            for (CloudServicePlan servicePlan : serviceOffering.getCloudServicePlans()) {
                CloudServicePlanNames.add(servicePlan.getName());
            }
            table.getHeaders().get(4).updateWidth(((Object)CloudServicePlanNames).toString().length() - 1);
            tableRow.addValue(4, ((Object)CloudServicePlanNames).toString().substring(1, ((Object)CloudServicePlanNames).toString().length() - 1));
            table.getHeaders().get(5).updateWidth(serviceOffering.getDescription().length());
            tableRow.addValue(5, serviceOffering.getDescription());
            table.getRows().add(tableRow);
        }
        return UiUtils.renderTextTable(table);
    }

    public static String renderServiceDataAsTable(List<CloudService> services, Map<String, List<String>> servicesToApps) {
        Comparator<CloudService> nameComparator = new Comparator<CloudService>(){

            @Override
            public int compare(CloudService a, CloudService b) {
                return a.getName().compareTo(b.getName());
            }
        };
        Collections.sort(services, nameComparator);
        Table table = new Table();
        table.getHeaders().put(1, new TableHeader("name"));
        table.getHeaders().put(2, new TableHeader("service"));
        table.getHeaders().put(3, new TableHeader("provider"));
        table.getHeaders().put(4, new TableHeader("version"));
        table.getHeaders().put(5, new TableHeader("plan"));
        table.getHeaders().put(6, new TableHeader("bound apps"));
        for (CloudService service : services) {
            TableRow tableRow = new TableRow();
            table.getHeaders().get(1).updateWidth(service.getName().length());
            tableRow.addValue(1, service.getName());
            table.getHeaders().get(2).updateWidth(service.getLabel().length());
            tableRow.addValue(2, service.getLabel());
            table.getHeaders().get(3).updateWidth(service.getProvider().length());
            tableRow.addValue(3, service.getProvider());
            table.getHeaders().get(4).updateWidth(service.getVersion().length());
            tableRow.addValue(4, service.getVersion());
            table.getHeaders().get(5).updateWidth(service.getPlan().length());
            tableRow.addValue(5, service.getPlan());
            List<String> appNames = servicesToApps.get(service.getName());
            String appNamesString = CommonUtils.collectionToCommaDelimitedString(appNames);
            table.getHeaders().get(6).updateWidth(appNamesString.length());
            tableRow.addValue(6, appNamesString);
            table.getRows().add(tableRow);
        }
        return UiUtils.renderTextTable(table);
    }

    public static String renderParameterInfoDataAsTable(Map<String, String> parameters) {
        Table table = new Table();
        table.getHeaders().put(1, new TableHeader("Parameter"));
        table.getHeaders().put(2, new TableHeader("Value (Configured or Default)"));
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            TableRow tableRow = new TableRow();
            table.getHeaders().get(1).updateWidth(entry.getKey().length());
            tableRow.addValue(1, entry.getKey());
            table.getHeaders().get(2).updateWidth(entry.getValue() != null ? entry.getValue().length() : 0);
            tableRow.addValue(2, entry.getValue());
            table.getRows().add(tableRow);
        }
        return UiUtils.renderTextTable(table);
    }

    public static String renderTextTable(Table table) {
        String padding = "  ";
        String headerBorder = UiUtils.getHeaderBorder(table.getHeaders());
        StringBuilder textTable = new StringBuilder();
        for (TableHeader header : table.getHeaders().values()) {
            textTable.append("  " + CommonUtils.padRight(header.getName(), header.getWidth()));
        }
        textTable.append("\n");
        textTable.append(headerBorder);
        for (TableRow row : table.getRows()) {
            for (Map.Entry<Integer, TableHeader> entry : table.getHeaders().entrySet()) {
                textTable.append("  " + CommonUtils.padRight(row.getValue(entry.getKey()), entry.getValue().getWidth()));
            }
            textTable.append("\n");
        }
        return textTable.toString();
    }

    public static String renderCloudInfoFormattedAsString(CloudInfo cloudInfo, String target, String org, String space) {
        StringBuilder sb = new StringBuilder("\n");
        sb.append(HORIZONTAL_LINE);
        sb.append(String.format("CF instance: %s (API version: %s) \n", target, cloudInfo.getVersion()));
        sb.append(String.format("  user:        %s\n", cloudInfo.getUser()));
        sb.append(String.format("  target app space: %s (org: %s) \n", target, org, space));
        sb.append(HORIZONTAL_LINE);
        return sb.toString();
    }

    public static String getHeaderBorder(Map<Integer, TableHeader> headers) {
        StringBuilder headerBorder = new StringBuilder();
        for (TableHeader header : headers.values()) {
            headerBorder.append(CommonUtils.padRight("  ", header.getWidth() + 2, '-'));
        }
        headerBorder.append("\n");
        return headerBorder.toString();
    }
}

