/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javacc;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.javacc.AbstractJavaCCMojo;
import org.codehaus.mojo.javacc.GrammarInfo;
import org.codehaus.mojo.javacc.JJTree;
import org.codehaus.mojo.javacc.JavaCC;

public class JJTreeJavaCCMojo
extends AbstractJavaCCMojo {
    private Boolean buildNodeFiles;
    private Boolean multi;
    private Boolean nodeDefaultVoid;
    private String nodeClass;
    private String nodeFactory;
    private String nodePackage;
    private String nodePrefix;
    private Boolean nodeScopeHook;
    private Boolean nodeUsesParser;
    private Boolean trackTokens;
    private Boolean visitor;
    private String visitorDataType;
    private String visitorReturnType;
    private String visitorException;
    private File sourceDirectory;
    private File interimDirectory;
    private File outputDirectory;
    private String[] includes;
    private String[] excludes;
    private int staleMillis;

    protected File getSourceDirectory() {
        return this.sourceDirectory;
    }

    protected String[] getIncludes() {
        if (this.includes != null) {
            return this.includes;
        }
        return new String[]{"**/*.jj", "**/*.JJ", "**/*.jjt", "**/*.JJT"};
    }

    protected String[] getExcludes() {
        return this.excludes;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected int getStaleMillis() {
        return this.staleMillis;
    }

    private File getInterimDirectory() {
        return this.interimDirectory;
    }

    protected File[] getCompileSourceRoots() {
        return new File[]{this.getOutputDirectory(), this.getInterimDirectory()};
    }

    protected void processGrammar(GrammarInfo grammarInfo) throws MojoExecutionException, MojoFailureException {
        File jjtFile = grammarInfo.getGrammarFile();
        File jjtDirectory = jjtFile.getParentFile();
        File tempDirectory = this.getTempDirectory();
        File jjDirectory = new File(tempDirectory, "node");
        File parserDirectory = new File(tempDirectory, "parser");
        String nodePackageName = grammarInfo.resolvePackageName(this.nodePackage);
        JJTree jjtree = this.newJJTree();
        jjtree.setInputFile(jjtFile);
        jjtree.setOutputDirectory(jjDirectory);
        jjtree.setNodePackage(nodePackageName);
        jjtree.run();
        JavaCC javacc = this.newJavaCC();
        javacc.setInputFile(jjtree.getOutputFile());
        javacc.setOutputDirectory(parserDirectory);
        javacc.run();
        this.copyGrammarOutput(this.getInterimDirectory(), nodePackageName != null ? nodePackageName : grammarInfo.getParserPackage(), jjDirectory, grammarInfo.getParserName() + "TreeConstants*");
        this.copyGrammarOutput(this.getOutputDirectory(), grammarInfo.getParserPackage(), parserDirectory, grammarInfo.getParserName() + "*");
        if (!this.isSourceRoot(grammarInfo.getSourceDirectory())) {
            this.copyGrammarOutput(this.getOutputDirectory(), grammarInfo.getParserPackage(), jjtDirectory, "*");
        }
        this.deleteTempDirectory(tempDirectory);
    }

    protected JJTree newJJTree() {
        JJTree jjtree = new JJTree();
        jjtree.setLog(this.getLog());
        jjtree.setJdkVersion(this.getJdkVersion());
        jjtree.setStatic(this.getIsStatic());
        jjtree.setBuildNodeFiles(this.buildNodeFiles);
        jjtree.setMulti(this.multi);
        jjtree.setNodeDefaultVoid(this.nodeDefaultVoid);
        jjtree.setNodeClass(this.nodeClass);
        jjtree.setNodeFactory(this.nodeFactory);
        jjtree.setNodePrefix(this.nodePrefix);
        jjtree.setNodeScopeHook(this.nodeScopeHook);
        jjtree.setNodeUsesParser(this.nodeUsesParser);
        jjtree.setTrackTokens(this.trackTokens);
        jjtree.setVisitor(this.visitor);
        jjtree.setVisitorDataType(this.visitorDataType);
        jjtree.setVisitorReturnType(this.visitorReturnType);
        jjtree.setVisitorException(this.visitorException);
        return jjtree;
    }
}

