/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ruby;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.ruby.RubyMojo;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.jruby.JRubyInvoker;
import org.codehaus.plexus.component.jruby.JRubyRuntimeInvoker;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.util.StringOutputStream;
import org.jruby.exceptions.RaiseException;

public class DefaultRubyMojo
extends AbstractMojo
implements RubyMojo {
    private JRubyInvoker jinvoker;
    private Object returned;

    public DefaultRubyMojo(JRubyInvoker invoker) {
        this.jinvoker = invoker;
    }

    public void set(String key, Object value) {
        if ("basedir".equals(key)) {
            this.jinvoker.setCurrentDirectory(value.toString());
            this.jinvoker.putGlobal(key, value);
        } else if (!"libraryPaths".equals(key)) {
            if ("requires".equals(key)) {
                this.jinvoker.setRequires((String[])value);
            } else {
                this.jinvoker.putGlobal(key, value);
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StringOutputStream stdout = new StringOutputStream();
        StringOutputStream stderr = new StringOutputStream();
        try {
            this.returned = this.jinvoker.invoke((OutputStream)stdout, (OutputStream)stderr);
            if (this.returned instanceof Mojo) {
                ((Mojo)this.returned).execute();
            }
        }
        catch (RaiseException e) {
            JRubyRuntimeInvoker.printREStackTrace((RaiseException)e, (OutputStream)stderr);
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (Throwable e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            try {
                stdout.flush();
                this.logOutput(stdout.toString(), false);
                stdout.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                stderr.flush();
                this.logOutput(stderr.toString(), true);
                stderr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Object getReturned() {
        return this.returned;
    }

    private void logOutput(String output, boolean error) {
        if (output != null && output.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(output, "\n");
            while (tokens.hasMoreTokens()) {
                if (error) {
                    this.getLog().error((CharSequence)tokens.nextToken());
                    continue;
                }
                this.getLog().info((CharSequence)tokens.nextToken());
            }
        }
    }

    public void addComponentRequirement(ComponentRequirement componentrequirement, Object obj) throws ComponentConfigurationException {
        this.set(componentrequirement.getFieldName(), obj);
    }

    public void setComponentConfiguration(Map map) throws ComponentConfigurationException {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.set((String)entry.getKey(), entry.getValue());
        }
    }
}

