/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.download;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Proxy;
import org.codehaus.mojo.license.download.FileNameEntry;
import org.codehaus.mojo.license.spdx.SpdxLicenseList;
import org.codehaus.mojo.license.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseDownloader
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseDownloader.class);
    private static final Pattern EXTENSION_PATTERN = Pattern.compile("\\.[a-z]{1,4}$", 2);
    private final CloseableHttpClient client;
    private final Map<String, SpdxLicenseList.Attachments.ContentSanitizer> contentSanitizers;
    private final Charset charset;

    public LicenseDownloader(Proxy proxy, int connectTimeout, int socketTimeout, int connectionRequestTimeout, Map<String, SpdxLicenseList.Attachments.ContentSanitizer> contentSanitizers, Charset charset) {
        this.contentSanitizers = contentSanitizers;
        this.charset = charset;
        RequestConfig.Builder configBuilder = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).setCookieSpec("standard").setConnectionRequestTimeout(connectionRequestTimeout);
        if (proxy != null) {
            configBuilder.setProxy(new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol()));
        }
        HttpClientBuilder clientBuilder = HttpClients.custom().setDefaultRequestConfig(configBuilder.build());
        if (proxy != null) {
            String[] nonProxyHosts;
            String rawNonProxyHosts;
            if (proxy.getUsername() != null && proxy.getPassword() != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword());
                credsProvider.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), (Credentials)creds);
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            if ((rawNonProxyHosts = proxy.getNonProxyHosts()) != null && (nonProxyHosts = rawNonProxyHosts.split("|")).length > 0) {
                final ArrayList<Pattern> nonProxyPatterns = new ArrayList<Pattern>();
                for (String nonProxyHost : nonProxyHosts) {
                    Pattern pat = Pattern.compile(nonProxyHost.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"), 2);
                    nonProxyPatterns.add(pat);
                }
                HttpHost proxyHost = new HttpHost(proxy.getHost(), proxy.getPort());
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost){

                    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
                        for (Pattern pattern : nonProxyPatterns) {
                            if (!pattern.matcher(target.getHostName()).matches()) continue;
                            return null;
                        }
                        return super.determineProxy(target, request, context);
                    }
                };
                clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            }
        }
        this.client = clientBuilder.build();
    }

    /*
     * Exception decompiling
     */
    public LicenseDownloadResult downloadLicense(String licenseUrlString, FileNameEntry fileNameEntry) throws IOException, URISyntaxException, MojoFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static LicenseDownloadResult sanitize(BufferedReader r, File out, Charset charset, List<SpdxLicenseList.Attachments.ContentSanitizer> sanitizers, boolean preferredFileName) throws IOException {
        StringBuilder contentBuilder = new StringBuilder();
        char[] buffer = new char[8192];
        int len = 0;
        while ((len = r.read(buffer)) >= 0) {
            contentBuilder.append(buffer, 0, len);
        }
        String content = contentBuilder.toString();
        for (SpdxLicenseList.Attachments.ContentSanitizer sanitizer : sanitizers) {
            content = sanitizer.sanitize(content);
        }
        byte[] bytes = content.getBytes(charset);
        Files.write(out.toPath(), bytes, new OpenOption[0]);
        String sha1 = DigestUtils.sha1Hex((byte[])bytes);
        return LicenseDownloadResult.success(out, sha1, preferredFileName);
    }

    List<SpdxLicenseList.Attachments.ContentSanitizer> filterSanitizers(String licenseUrlString) {
        ArrayList<SpdxLicenseList.Attachments.ContentSanitizer> result = new ArrayList<SpdxLicenseList.Attachments.ContentSanitizer>();
        for (SpdxLicenseList.Attachments.ContentSanitizer s : this.contentSanitizers.values()) {
            if (!s.applies(licenseUrlString)) continue;
            result.add(s);
        }
        return result;
    }

    static File updateFileExtension(File outputFile, String mimeType) {
        String oldFileName;
        String realExtension = FileUtil.toExtension(mimeType, false);
        if (realExtension == null) {
            realExtension = ".txt";
        }
        if (!(oldFileName = outputFile.getName()).endsWith(realExtension)) {
            String newFileName = EXTENSION_PATTERN.matcher(oldFileName).replaceAll("") + realExtension;
            return new File(outputFile.getParentFile(), newFileName);
        }
        return outputFile;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public static class LicenseDownloadResult {
        private final File file;
        private final String errorMessage;
        private final String sha1;
        private final boolean preferredFileName;

        public static LicenseDownloadResult success(File file, String sha1, boolean preferredFileName) {
            return new LicenseDownloadResult(file, sha1, preferredFileName, null);
        }

        public static LicenseDownloadResult failure(String errorMessage) {
            return new LicenseDownloadResult(null, null, false, errorMessage);
        }

        private LicenseDownloadResult(File file, String sha1, boolean preferredFileName, String errorMessage) {
            this.file = file;
            this.errorMessage = errorMessage;
            this.sha1 = sha1;
            this.preferredFileName = preferredFileName;
        }

        public File getFile() {
            return this.file;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean isSuccess() {
            return this.errorMessage == null;
        }

        public boolean isPreferredFileName() {
            return this.preferredFileName;
        }

        public String getSha1() {
            return this.sha1;
        }

        public LicenseDownloadResult withFile(File otherFile) {
            return new LicenseDownloadResult(otherFile, this.sha1, this.preferredFileName, this.errorMessage);
        }
    }
}

