/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.pde.descriptor;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.pde.descriptor.Descriptor;
import org.codehaus.mojo.pde.descriptor.FeatureDescriptor;
import org.codehaus.mojo.pde.descriptor.FragmentDescriptor;
import org.codehaus.mojo.pde.descriptor.ManifestBean;
import org.codehaus.mojo.pde.descriptor.PluginDescriptor;
import org.codehaus.mojo.pde.descriptor.ProductDescriptor;
import org.codehaus.mojo.pde.descriptor.io.xpp3.FeatureXpp3Reader;
import org.codehaus.mojo.pde.descriptor.io.xpp3.FragmentXpp3Reader;
import org.codehaus.mojo.pde.descriptor.io.xpp3.PluginXpp3Reader;
import org.codehaus.mojo.pde.descriptor.io.xpp3.ProductXpp3Reader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DescriptorUtil {
    public static Descriptor getDescriptor(File basedir, String productFilename) throws MojoExecutionException {
        Descriptor d = null;
        if (productFilename != null) {
            d = DescriptorUtil.loadProductDescriptor(basedir, productFilename);
        } else {
            d = DescriptorUtil.loadFeatureDescriptor(basedir);
            if (d == null) {
                d = DescriptorUtil.loadFragmentDescriptor(basedir);
            }
            if (d == null) {
                d = DescriptorUtil.loadPluginDescriptor(basedir);
            }
        }
        if (d == null) {
            throw new MojoExecutionException(basedir.getPath() + " is not a PDE project.");
        }
        return d;
    }

    private static Descriptor loadFeatureDescriptor(File basedir) throws MojoExecutionException {
        FeatureDescriptor descriptor = null;
        File file = new File(basedir, "feature.xml");
        if (file.exists()) {
            try {
                descriptor = DescriptorUtil.readFeatureDescriptor(new FileReader(file));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading " + file);
            }
        }
        return descriptor;
    }

    private static Descriptor loadFragmentDescriptor(File basedir) throws MojoExecutionException {
        FeatureDescriptor descriptor = null;
        File file = new File(basedir, "fragment.xml");
        if (file.exists()) {
            try {
                descriptor = DescriptorUtil.readFeatureDescriptor(new FileReader(file));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading " + file);
            }
        }
        return descriptor;
    }

    private static Descriptor loadPluginDescriptor(File basedir) throws MojoExecutionException {
        PluginDescriptor d = null;
        File file = new File(basedir, "plugin.xml");
        if (file.exists()) {
            try {
                d = DescriptorUtil.readPluginDescriptor(new FileReader(file));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading " + file);
            }
        } else {
            d = new PluginDescriptor();
        }
        if (d.getId() == null || d.getVersion() == null) {
            ManifestBean bean = new ManifestBean(basedir);
            if (d.getId() == null) {
                d.setId(bean.getId());
            }
            if (d.getVersion() == null) {
                d.setVersion(bean.getVersion());
            }
        }
        return d;
    }

    private static Descriptor loadProductDescriptor(File basedir, String productFilename) throws MojoExecutionException {
        ProductDescriptor d = null;
        File file = new File(basedir, productFilename);
        if (file.exists()) {
            try {
                d = DescriptorUtil.readProductDescriptor(new FileReader(file));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading " + file);
            }
        }
        return d;
    }

    public static PluginDescriptor readPluginDescriptor(Reader reader) throws MojoExecutionException {
        PluginDescriptor descriptor;
        try {
            PluginXpp3Reader r = new PluginXpp3Reader();
            descriptor = r.read(reader, false);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading plugin.xml descriptor", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error reading plugin.xml descriptor", (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return descriptor;
    }

    public static FeatureDescriptor readFeatureDescriptor(Reader reader) throws MojoExecutionException {
        FeatureDescriptor descriptor;
        try {
            FeatureXpp3Reader r = new FeatureXpp3Reader();
            descriptor = r.read(reader, false);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading feature.xml descriptor", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error reading feature.xml descriptor", (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return descriptor;
    }

    public static FragmentDescriptor readFragmentDescriptor(Reader reader) throws MojoExecutionException {
        FragmentDescriptor descriptor;
        try {
            FragmentXpp3Reader r = new FragmentXpp3Reader();
            descriptor = r.read(reader, false);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading fragment.xml descriptor", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error reading fragment.xml descriptor", (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return descriptor;
    }

    public static ProductDescriptor readProductDescriptor(Reader reader) throws MojoExecutionException {
        ProductDescriptor descriptor;
        try {
            ProductXpp3Reader r = new ProductXpp3Reader();
            descriptor = r.read(reader, false);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading *.product descriptor", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error reading *.product descriptor", (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return descriptor;
    }

    public static String getPDEType(Descriptor descriptor) {
        if (descriptor instanceof ProductDescriptor) {
            return "product";
        }
        if (descriptor instanceof PluginDescriptor) {
            return "plugin";
        }
        if (descriptor instanceof FeatureDescriptor) {
            return "feature";
        }
        if (descriptor instanceof FragmentDescriptor) {
            return "fragment";
        }
        return null;
    }
}

