/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.rpm.AbstractRPMMojo;
import org.codehaus.mojo.rpm.BaseTrigger;
import org.codehaus.mojo.rpm.Mapping;
import org.codehaus.mojo.rpm.Scriptlet;
import org.codehaus.mojo.rpm.SoftlinkSource;
import org.codehaus.plexus.util.DirectoryScanner;

final class SpecWriter {
    private final AbstractRPMMojo mojo;
    private final PrintWriter spec;

    public SpecWriter(AbstractRPMMojo mojo, PrintWriter spec) {
        this.mojo = mojo;
        this.spec = spec;
    }

    public void writeSpecFile() throws MojoExecutionException, IOException {
        this.writeList(this.mojo.getDefineStatements(), "%define ");
        this.spec.println("Name: " + this.mojo.getName());
        this.spec.println("Version: " + this.mojo.getVersion());
        this.spec.println("Release: " + this.mojo.getRelease());
        this.writeNonNullDirective("Summary", this.mojo.getSummary());
        this.writeNonNullDirective("License", this.mojo.getCopyright());
        this.writeNonNullDirective("Distribution", this.mojo.getDistribution());
        if (this.mojo.getIcon() != null) {
            this.spec.println("Icon: " + this.mojo.getIcon().getName());
        }
        this.writeNonNullDirective("Vendor", this.mojo.getVendor());
        this.writeNonNullDirective("URL", this.mojo.getUrl());
        this.writeNonNullDirective("Group", this.mojo.getGroup());
        this.writeNonNullDirective("Packager", this.mojo.getPackager());
        this.writeList(this.mojo.getProvides(), "Provides: ");
        this.writeList(this.mojo.getRequires(), "Requires: ");
        this.writeList(this.mojo.getPrereqs(), "PreReq: ");
        this.writeList(this.mojo.getObsoletes(), "Obsoletes: ");
        this.writeList(this.mojo.getConflicts(), "Conflicts: ");
        this.spec.println("autoprov: " + (this.mojo.isAutoProvides() ? "yes" : "no"));
        this.spec.println("autoreq: " + (this.mojo.isAutoRequires() ? "yes" : "no"));
        if (this.mojo.getPrefix() != null) {
            this.spec.println("Prefix: " + this.mojo.getPrefix());
        }
        this.spec.println("BuildRoot: " + this.mojo.getRPMBuildroot().getAbsolutePath());
        this.spec.println();
        this.spec.println("%description");
        if (this.mojo.getDescription() != null) {
            this.spec.println(this.mojo.getDescription());
        }
        this.writeMove();
        this.writeLinks();
        if (this.mojo.getInstallScriptlet() != null) {
            this.spec.println();
            this.mojo.getInstallScriptlet().writeContent(this.spec);
        }
        this.writeFiles();
        this.writeScripts();
        if (this.mojo.getTriggers() != null) {
            for (BaseTrigger trigger : this.mojo.getTriggers()) {
                trigger.writeTrigger(this.spec);
            }
        }
        if (this.mojo.getChangelog() != null) {
            this.spec.println();
            this.spec.println("%changelog");
            this.spec.println(this.mojo.getChangelog());
        }
    }

    private void writeFiles() {
        Log log = this.mojo.getLog();
        this.spec.println();
        this.spec.println("%files");
        this.spec.println(this.getDefAttrString());
        for (Mapping map : this.mojo.getMappings()) {
            int i;
            String destination = map.getDestination();
            File absoluteDestination = map.getAbsoluteDestination();
            if (map.hasSoftLinks() && !absoluteDestination.exists()) {
                log.debug((CharSequence)("writing attribute string for directory created by soft link: " + destination));
                String attributes = map.getAttrString(this.mojo.getDefaultFilemode(), this.mojo.getDefaultGroupname(), this.mojo.getDefaultUsername());
                this.spec.println(attributes + " \"" + destination + "\"");
                continue;
            }
            List includes = map.getCopiedFileNamesRelativeToDestination();
            List links = map.getLinkedFileNamesRelativeToDestination();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(absoluteDestination);
            scanner.setIncludes(includes.isEmpty() ? null : includes.toArray(new String[includes.size()]));
            scanner.setExcludes(null);
            scanner.scan();
            String attrString = map.getAttrString(this.mojo.getDefaultFilemode(), this.mojo.getDefaultGroupname(), this.mojo.getDefaultUsername());
            if (scanner.isEverythingIncluded() && links.isEmpty() && map.isDirectoryIncluded() && !map.isRecurseDirectories()) {
                log.debug((CharSequence)("writing attribute string for directory: " + destination));
                this.spec.println(attrString + " \"" + destination + "\"");
                continue;
            }
            log.debug((CharSequence)("writing attribute string for identified files in directory: " + destination));
            String baseFileString = attrString + "  \"" + destination + File.separatorChar;
            if (!(map.isDirectoryIncluded() && scanner.isEverythingIncluded() && links.isEmpty())) {
                String[] files = scanner.getIncludedFiles();
                for (i = 0; i < files.length; ++i) {
                    this.spec.print(baseFileString);
                    this.spec.println(files[i] + "\"");
                }
            }
            if (map.isRecurseDirectories()) {
                String[] dirs = scanner.getIncludedDirectories();
                if (map.isDirectoryIncluded()) {
                    this.spec.println(baseFileString + "\"");
                }
                for (i = 0; i < dirs.length; ++i) {
                    if (dirs[i].length() <= 0) continue;
                    this.spec.print(baseFileString);
                    this.spec.println(dirs[i] + "\"");
                }
            }
            for (String link : links) {
                this.spec.print(baseFileString);
                this.spec.println(link + "\"");
            }
        }
    }

    private void writeMove() {
        String tmpBuildRoot = this.mojo.getBuildroot().getAbsolutePath();
        this.spec.println();
        this.spec.println("%install");
        this.spec.println("if [ -e $RPM_BUILD_ROOT ];");
        this.spec.println("then");
        this.spec.print("  mv ");
        this.spec.print(tmpBuildRoot);
        this.spec.println("/* $RPM_BUILD_ROOT");
        this.spec.println("else");
        this.spec.print("  mv ");
        this.spec.print(tmpBuildRoot);
        this.spec.println(" $RPM_BUILD_ROOT");
        this.spec.println("fi");
    }

    private void writeLinks() {
        if (!this.mojo.getLinkTargetToSources().isEmpty()) {
            this.spec.println();
            for (Map.Entry directoryToSourcesEntry : this.mojo.getLinkTargetToSources().entrySet()) {
                List sources;
                int sourceCnt;
                String directory = (String)directoryToSourcesEntry.getKey();
                if (directory.startsWith("/")) {
                    directory = directory.substring(1);
                }
                if (directory.endsWith("/")) {
                    directory = directory.substring(0, directory.length() - 1);
                }
                if ((sourceCnt = (sources = (List)directoryToSourcesEntry.getValue()).size()) == 1) {
                    SoftlinkSource linkSource = (SoftlinkSource)sources.get(0);
                    String macroEvaluatedLocation = linkSource.getMacroEvaluatedLocation();
                    File buildSourceLocation = macroEvaluatedLocation.startsWith("/") ? new File(this.mojo.getBuildroot(), macroEvaluatedLocation) : new File(this.mojo.getBuildroot(), directory + '/' + macroEvaluatedLocation);
                    if (buildSourceLocation.isDirectory()) {
                        DirectoryScanner scanner = SpecWriter.scanLinkSource(linkSource, buildSourceLocation);
                        if (scanner.isEverythingIncluded()) {
                            File destinationFile = linkSource.getSourceMapping().getAbsoluteDestination();
                            destinationFile.delete();
                            this.spec.print("ln -s ");
                            this.spec.print(linkSource.getLocation());
                            this.spec.print(" $RPM_BUILD_ROOT/");
                            this.spec.print(directory);
                            String dest = linkSource.getDestination();
                            if (dest != null) {
                                this.spec.print('/');
                                this.spec.print(dest);
                                linkSource.getSourceMapping().addLinkedFileNameRelativeToDestination(dest);
                            }
                            this.spec.println();
                            continue;
                        }
                        this.linkScannedFiles(directory, linkSource, scanner);
                        continue;
                    }
                    this.linkSingleFile(directory, linkSource);
                    continue;
                }
                for (SoftlinkSource linkSource : sources) {
                    String sourceLocation = linkSource.getMacroEvaluatedLocation();
                    File buildSourceLocation = sourceLocation.startsWith("/") ? new File(this.mojo.getBuildroot(), sourceLocation) : new File(this.mojo.getBuildroot(), directory + '/' + sourceLocation);
                    if (buildSourceLocation.isDirectory()) {
                        DirectoryScanner scanner = SpecWriter.scanLinkSource(linkSource, buildSourceLocation);
                        this.linkScannedFiles(directory, linkSource, scanner);
                        continue;
                    }
                    this.linkSingleFile(directory, linkSource);
                }
            }
        }
    }

    private void linkScannedFiles(String directory, SoftlinkSource linkSource, DirectoryScanner scanner) {
        String[] files = scanner.getIncludedFiles();
        String sourceLocation = linkSource.getLocation();
        String targetPrefix = sourceLocation + File.separatorChar;
        String sourcePrefix = directory + File.separatorChar;
        for (int i = 0; i < files.length; ++i) {
            this.spec.print("ln -s ");
            this.spec.print(targetPrefix + files[i]);
            this.spec.print(" $RPM_BUILD_ROOT/");
            this.spec.println(sourcePrefix + files[i]);
            linkSource.getSourceMapping().addLinkedFileNameRelativeToDestination(files[i]);
        }
    }

    private static DirectoryScanner scanLinkSource(SoftlinkSource linkSource, File buildSourceLocation) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(buildSourceLocation);
        List includes = linkSource.getIncludes();
        scanner.setIncludes(includes == null || includes.isEmpty() ? null : includes.toArray(new String[includes.size()]));
        List excludes = linkSource.getExcludes();
        scanner.setExcludes(excludes == null || excludes.isEmpty() ? null : excludes.toArray(new String[excludes.size()]));
        scanner.scan();
        return scanner;
    }

    private String getDefAttrString() {
        String defaultFilemode = this.mojo.getDefaultFilemode();
        String defaultUsername = this.mojo.getDefaultUsername();
        String defaultGroupname = this.mojo.getDefaultGroupname();
        String defaultDirmode = this.mojo.getDefaultDirmode();
        if (defaultFilemode == null && defaultUsername == null && defaultGroupname == null && this.mojo.getDefaultDirmode() == null && defaultDirmode == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (defaultFilemode != null) {
            sb.append("%defattr(").append(defaultFilemode).append(",");
        } else {
            sb.append("%defattr(-,");
        }
        if (defaultUsername != null) {
            sb.append(defaultUsername).append(",");
        } else {
            sb.append("-,");
        }
        if (defaultGroupname != null) {
            sb.append(defaultGroupname).append(",");
        } else {
            sb.append("-,");
        }
        if (defaultDirmode != null) {
            sb.append(defaultDirmode).append(")");
        } else {
            sb.append("-)");
        }
        return sb.toString();
    }

    private void linkSingleFile(String directory, SoftlinkSource linkSource) {
        this.spec.print("ln -s ");
        this.spec.print(linkSource.getLocation());
        this.spec.print(" $RPM_BUILD_ROOT/");
        this.spec.print(directory);
        this.spec.print('/');
        String destination = linkSource.getDestination();
        String linkedFileName = destination == null ? new File(linkSource.getMacroEvaluatedLocation()).getName() : destination;
        this.spec.println(linkedFileName);
        linkSource.getSourceMapping().addLinkedFileNameRelativeToDestination(linkedFileName);
    }

    private void writeScripts() throws IOException {
        Scriptlet[] scriptlets = new Scriptlet[]{this.mojo.getPrepareScriptlet(), this.mojo.getPretransScriptlet(), this.mojo.getPreinstallScriptlet(), this.mojo.getPostinstallScriptlet(), this.mojo.getPreremoveScriptlet(), this.mojo.getPostremoveScriptlet(), this.mojo.getPosttransScriptlet(), this.mojo.getVerifyScriptlet(), this.mojo.getCleanScriptlet()};
        String[] directives = new String[]{"%prep", "%pretrans", "%pre", "%post", "%preun", "%postun", "%posttrans", "%verifyscript", "%clean"};
        for (int i = 0; i < scriptlets.length; ++i) {
            if (scriptlets[i] == null) continue;
            scriptlets[i].write(this.spec, directives[i]);
        }
    }

    private void writeNonNullDirective(String directive, String value) {
        if (value != null) {
            this.spec.print(directive);
            this.spec.print(": ");
            this.spec.println(value);
        }
    }

    private void writeList(Collection strings, String prefix) {
        if (strings != null) {
            Iterator it = strings.iterator();
            while (it.hasNext()) {
                this.spec.print(prefix);
                this.spec.println(it.next());
            }
        }
    }
}

