/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rspec;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;

public class RspecRunnerMojo
extends AbstractMojo {
    protected List<String> classpathElements;
    protected String sourceDirectory;
    protected String outputDirectory;
    protected String reportName;
    protected String jrubyHome;
    protected boolean ignoreFailure;
    protected boolean skipTests;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests) {
            this.getLog().info((CharSequence)"Skipping RSpec tests");
            return;
        }
        this.getLog().info((CharSequence)("Running RSpec tests from " + this.sourceDirectory));
        if (this.jrubyHome == null) {
            throw new MojoExecutionException("jrubyHome directory not specified");
        }
        Ruby runtime = Ruby.newInstance();
        runtime.setJRubyHome(this.jrubyHome);
        runtime.getLoadService().init(this.classpathElements);
        StringBuilder script = new StringBuilder();
        try {
            script.append(this.handleClasspathElements(runtime));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        String reportPath = this.outputDirectory + "/" + this.reportName;
        script.append("require 'rubygems'\n").append("require 'spec'\n").append("spec_dir = '").append(this.sourceDirectory).append("'\n").append("report_file = '").append(reportPath).append("'\n").append("options = ::Spec::Runner::OptionParser.parse([spec_dir, '-f', \"html#{report_file}\"], STDERR, STDOUT)\n").append("::Spec::Runner::CommandLine.run(options)\n");
        script.append("if File.new(report_file, 'r').read =~ /, 0 failures/ \n").append(" false\n").append("else\n").append(" true\n").append("end");
        RubyBoolean failure = (RubyBoolean)runtime.evalScriptlet(script.toString());
        if (failure.isTrue()) {
            String message = "RSpec tests failed. See '" + reportPath + "' for details.";
            this.getLog().warn((CharSequence)message);
            if (!this.ignoreFailure) {
                throw new MojoFailureException(message);
            }
        } else {
            this.getLog().info((CharSequence)("RSpec tests successful. See '" + reportPath + "' for details."));
        }
    }

    private String handleClasspathElements(Ruby runtime) throws MalformedURLException {
        StringBuilder script = new StringBuilder();
        for (String path : this.classpathElements) {
            if (path.endsWith(".jar")) {
                script.append("require '").append(path).append("'\n");
                continue;
            }
            runtime.getJRubyClassLoader().addURL(new URL("file:" + path + "/"));
        }
        return script.toString();
    }
}

