package org.codehaus.mojo.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on sql-maven-plugin.<br/> Call <pre>  mvn sql:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Fri Aug 19 14:53:33 CEST 2011
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.7)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:sql-maven-plugin:1.5", 0 );
        append( sb, "", 0 );

        append( sb, "SQL Maven Plugin", 0 );
        append( sb, "Execute SQL Statements", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 2 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "execute".equals( goal ) )
        {
            append( sb, "sql:execute", 0 );
            append( sb, "Executes SQL against a database.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "autocommit (Default: false)", 2 );
                append( sb, "Set to true to execute none-transactional SQL.", 3 );
                append( sb, "Expression: ${autocommit}", 3 );
                append( sb, "", 0 );

                append( sb, "delimiter (Default: ;)", 2 );
                append( sb, "Set the delimiter that separates SQL statements.", 3 );
                append( sb, "Expression: ${delimiter}", 3 );
                append( sb, "", 0 );

                append( sb, "delimiterType (Default: normal)", 2 );
                append( sb, "The delimiter type takes two values - \'normal\' and \'row\'. Normal means that any occurrence of the delimiter terminate the SQL command whereas with row, only a line containing just the delimiter is recognized as the end of the command.\n\nFor example, set this to \'go\' and delimiterType to \'row\' for Sybase ASE or MS SQL Server.\n", 3 );
                append( sb, "Expression: ${delimiterType}", 3 );
                append( sb, "", 0 );

                append( sb, "driver", 2 );
                append( sb, "Database driver classname.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${driver}", 3 );
                append( sb, "", 0 );

                append( sb, "driverProperties", 2 );
                append( sb, "Additional key=value pairs separated by comma to be passed into JDBC driver.", 3 );
                append( sb, "Expression: ${driverProperties}", 3 );
                append( sb, "", 0 );

                append( sb, "enableAnonymousPassword (Default: false)", 2 );
                append( sb, "Ignore the password and use anonymous access. This may be useful for databases like MySQL which do not allow empty password parameters in the connection initialization.", 3 );
                append( sb, "", 0 );

                append( sb, "enableBlockMode", 2 );
                append( sb, "Deprecated. Use delimiterType instead.", 3 );
                append( sb, "", 0 );
                append( sb, "When true, the whole SQL content in sqlCommand, srcFiles and fileset are sent directly to JDBC in one SQL statement. This option is for executing database stored procedures/functions.", 3 );
                append( sb, "Expression: ${enableBlockMode}", 3 );
                append( sb, "", 0 );

                append( sb, "enableFiltering (Default: false)", 2 );
                append( sb, "Set to true if you want to filter the srcFiles using system-, user- and project properties", 3 );
                append( sb, "Expression: ${enableFiltering}", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Encoding to use when reading SQL statements from a file.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "escapeProcessing (Default: true)", 2 );
                append( sb, "Argument to Statement.setEscapeProcessing If you want the driver to use regular SQL syntax then set this to false.", 3 );
                append( sb, "Expression: ${escapeProcessing}", 3 );
                append( sb, "", 0 );

                append( sb, "fileset", 2 );
                append( sb, "File(s) containing SQL statements to load. Only use a Fileset if you want to use ant-like filepatterns, otherwise use srcFiles. The order is based on a matching occurrence while scanning the directory (not the order of includes!).", 3 );
                append( sb, "", 0 );

                append( sb, "forceMojoExecution (Default: false)", 2 );
                append( sb, "Setting this parameter to true will force the execution of this mojo, even if it would get skipped usually.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${forceOpenJpaExecution}", 3 );
                append( sb, "", 0 );

                append( sb, "keepFormat (Default: false)", 2 );
                append( sb, "Keep the format of an SQL block.", 3 );
                append( sb, "Expression: ${keepFormat}", 3 );
                append( sb, "", 0 );

                append( sb, "onError (Default: abort)", 2 );
                append( sb, "Action to perform if an error is found. Possible values are abort and continue.", 3 );
                append( sb, "Expression: ${onError}", 3 );
                append( sb, "", 0 );

                append( sb, "orderFile", 2 );
                append( sb, "Set the order in which the SQL files will be executed. Possible values are ascending and descending. Any other value means that no sorting will be performed. Refers to fileset and srcFiles", 3 );
                append( sb, "Expression: ${orderFile}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDelimiter (Default: ,)", 2 );
                append( sb, "The delimiter used to separate fields in the output when using printResultSet.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile", 2 );
                append( sb, "Dump the SQL execution\'s output to a file.\nDefault value is: System.out.", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "Database password. If not given, it will be looked up through settings.xml\'s server with ${settingsKey} as key.", 3 );
                append( sb, "Expression: ${password}", 3 );
                append( sb, "", 0 );

                append( sb, "printResultSet (Default: false)", 2 );
                append( sb, "Print SQL results.", 3 );
                append( sb, "Expression: ${printResultSet}", 3 );
                append( sb, "", 0 );

                append( sb, "settingsKey", 2 );
                append( sb, "Server\'s id in settings.xml to look up username and password. Defaults to ${url} if not given.", 3 );
                append( sb, "Expression: ${settingsKey}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "When true, skip the execution.", 3 );
                append( sb, "", 0 );

                append( sb, "skipOnConnectionError (Default: false)", 2 );
                append( sb, "Skip execution when there is an error obtaining a connection. This is a special case to support databases, such as embedded Derby, that can shutdown the database via the URL (i.e. shutdown=true).", 3 );
                append( sb, "Expression: ${skipOnConnectionError}", 3 );
                append( sb, "", 0 );

                append( sb, "sqlCommand", 2 );
                append( sb, "SQL input commands separated by ${delimiter}.", 3 );
                append( sb, "Expression: ${sqlCommand}", 3 );
                append( sb, "", 0 );

                append( sb, "srcFiles", 2 );
                append( sb, "List of files containing SQL statements to load.", 3 );
                append( sb, "", 0 );

                append( sb, "url", 2 );
                append( sb, "Database URL.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${url}", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "Database username. If not given, it will be looked up through settings.xml\'s server with ${settingsKey} as key.", 3 );
                append( sb, "Expression: ${username}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "sql:help", 0 );
            append( sb, "Display help information on sql-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0sql:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
