/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.digest;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;

public class DigestUtils {
    private DigestUtils() {
    }

    public static String cleanChecksum(String rawChecksum, Digester digester, String expectedFilename) throws DigesterException {
        return DigestUtils.cleanChecksum(rawChecksum, digester.getAlgorithm(), expectedFilename);
    }

    public static String cleanChecksum(String checksum, String algorithm, String path) throws DigesterException {
        String trimmedChecksum = checksum.replace('\n', ' ').trim();
        String regex = algorithm.replaceAll("-", "") + "\\s*\\((.*?)\\)\\s*=\\s*([a-fA-F0-9]+)";
        Matcher m = Pattern.compile(regex).matcher(trimmedChecksum);
        if (m.matches()) {
            String filename = m.group(1);
            if (!DigestUtils.isValidChecksumPattern(filename, path)) {
                throw new DigesterException("Supplied checksum does not match checksum pattern");
            }
            trimmedChecksum = m.group(2);
        } else {
            m = Pattern.compile("([a-fA-F0-9]+)\\s+\\*?(.+)").matcher(trimmedChecksum);
            if (m.matches()) {
                String filename = m.group(2);
                if (!DigestUtils.isValidChecksumPattern(filename, path)) {
                    throw new DigesterException("Supplied checksum does not match checksum pattern");
                }
                trimmedChecksum = m.group(1);
            }
        }
        return trimmedChecksum;
    }

    private static boolean isValidChecksumPattern(String filename, String path) {
        return filename.endsWith(path) || "-".equals(filename);
    }
}

