/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Purge;
import org.sonar.api.batch.PurgeContext;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.batch.CoreJob;
import org.sonar.batch.ServerMetadata;
import org.sonar.core.purge.DefaultPurgeContext;

public class FinalizeSnapshotsJob
implements CoreJob {
    private DatabaseSession session;
    private Purge[] purges;
    private ServerMetadata server;
    private Snapshot snapshot;

    public FinalizeSnapshotsJob(ServerMetadata server, DatabaseSession session, Purge[] purges, Snapshot snapshot) {
        this.session = session;
        this.purges = purges;
        this.server = server;
        this.snapshot = snapshot;
    }

    public void execute(Project project, SensorContext context) {
        if (this.shouldExecuteOn(project)) {
            Snapshot previousLastSnapshot = this.getPreviousLastSnapshot(this.snapshot);
            this.updateFlags(this.snapshot, previousLastSnapshot);
            this.purge(this.snapshot, previousLastSnapshot);
        }
    }

    private boolean shouldExecuteOn(Project project) {
        return project.isRoot();
    }

    private Snapshot getPreviousLastSnapshot(Snapshot snapshot) {
        Query query = this.session.createQuery("SELECT s FROM " + Snapshot.class.getSimpleName() + " s " + "WHERE s.last=true AND s.resourceId=:resourceId");
        query.setParameter("resourceId", (Object)snapshot.getResourceId());
        return (Snapshot)this.session.getSingleResult(query, null);
    }

    private void updateFlags(Snapshot rootSnapshot, Snapshot previousLastSnapshot) {
        if (previousLastSnapshot != null && previousLastSnapshot.getCreatedAt().before(rootSnapshot.getCreatedAt())) {
            this.setFlags(previousLastSnapshot, false, null);
        }
        boolean isLast = previousLastSnapshot == null || previousLastSnapshot.getCreatedAt().before(rootSnapshot.getCreatedAt());
        this.setFlags(rootSnapshot, isLast, "P");
        LoggerFactory.getLogger(this.getClass()).info("ANALYSIS SUCCESSFUL, you can browse {}", (Object)this.server.getUrl());
    }

    private void setFlags(Snapshot snapshot, boolean last, String status) {
        String hql = "UPDATE " + Snapshot.class.getSimpleName() + " SET last=:last";
        if (status != null) {
            hql = hql + ", status=:status ";
        }
        hql = hql + " WHERE root_snapshot_id=:rootId OR id=:rootId OR (path LIKE :path AND root_snapshot_id=:pathRootId)";
        Query query = this.session.createQuery(hql);
        if (status != null) {
            query.setParameter("status", (Object)status);
            snapshot.setStatus(status);
        }
        query.setParameter("last", (Object)last);
        query.setParameter("rootId", (Object)snapshot.getId());
        query.setParameter("path", (Object)(snapshot.getPath() + snapshot.getId() + ".%"));
        query.setParameter("pathRootId", (Object)(snapshot.getRootId() == null ? snapshot.getId() : snapshot.getRootId()));
        query.executeUpdate();
        this.session.commit();
        snapshot.setLast(Boolean.valueOf(last));
    }

    private void purge(Snapshot currentSnapshot, Snapshot previousLastSnapshot) {
        Logger logger = LoggerFactory.getLogger(FinalizeSnapshotsJob.class);
        TimeProfiler profiler = new TimeProfiler(logger).start("Database optimization");
        PurgeContext context = this.createPurgeContext(currentSnapshot, previousLastSnapshot);
        logger.debug("Snapshots to purge: " + context);
        for (Purge purge : this.purges) {
            logger.debug("Executing {}...", (Object)purge.getClass().getName());
            purge.purge(context);
        }
        profiler.stop();
    }

    private PurgeContext createPurgeContext(Snapshot currentSnapshot, Snapshot previousLastSnapshot) {
        DefaultPurgeContext context = new DefaultPurgeContext(currentSnapshot);
        if (previousLastSnapshot != null && previousLastSnapshot.getCreatedAt().before(currentSnapshot.getCreatedAt())) {
            context.setLastSnapshotId(previousLastSnapshot.getId());
        }
        return context;
    }
}

