/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.maven.project.MavenProject;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.configuration.DatabaseConfiguration;
import org.sonar.api.resources.Project;
import org.sonar.batch.ResourceDatabaseConfiguration;

public class ProjectConfiguration
extends CompositeConfiguration {
    private PropertiesConfiguration runtimeConfiguration = new PropertiesConfiguration();

    public ProjectConfiguration(DatabaseSession session, Project project) {
        this.addConfiguration((Configuration)this.runtimeConfiguration);
        this.loadSystemSettings();
        this.loadProjectDatabaseSettings(session, project);
        this.loadMavenSettings(project.getPom());
        this.loadGlobalDatabaseSettings(session);
    }

    private void loadProjectDatabaseSettings(DatabaseSession session, Project project) {
        this.addConfiguration((Configuration)new ResourceDatabaseConfiguration(session, project.getKey()));
        for (Project parent = project.getParent(); parent != null && parent.getKey() != null; parent = parent.getParent()) {
            this.addConfiguration((Configuration)new ResourceDatabaseConfiguration(session, parent.getKey()));
        }
    }

    private void loadGlobalDatabaseSettings(DatabaseSession session) {
        this.addConfiguration((Configuration)new DatabaseConfiguration(session));
    }

    private void loadSystemSettings() {
        this.addConfiguration((Configuration)new SystemConfiguration());
        this.addConfiguration((Configuration)new EnvironmentConfiguration());
    }

    private void loadMavenSettings(MavenProject pom) {
        this.addConfiguration((Configuration)new MapConfiguration((Map)pom.getModel().getProperties()));
    }

    public void setProperty(String s, Object o) {
        this.runtimeConfiguration.setProperty(s, o);
    }
}

