/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.batch.CoreJob;
import org.sonar.batch.DecoratorsSelector;
import org.sonar.batch.DefaultDecoratorContext;
import org.sonar.batch.ViolationsDao;
import org.sonar.batch.indexer.DefaultSonarIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratorsExecutor
implements CoreJob {
    private DecoratorsSelector decoratorsSelector;
    private DatabaseSession session;
    private ViolationsDao violationsDao;
    private static final Logger LOG = LoggerFactory.getLogger(DecoratorsExecutor.class);
    private DefaultSonarIndex index;

    public DecoratorsExecutor(BatchExtensionDictionnary extensionDictionnary, DefaultSonarIndex index, DatabaseSession session, ViolationsDao violationsDao) {
        this.decoratorsSelector = new DecoratorsSelector(extensionDictionnary);
        this.session = session;
        this.violationsDao = violationsDao;
        this.index = index;
    }

    @Override
    public void execute(Project project, SensorContext sensorContext) {
        LoggerFactory.getLogger(DecoratorsExecutor.class).info("Execute decorators...");
        Collection<Decorator> decorators = this.decoratorsSelector.select(project);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decorators: {}", (Object)StringUtils.join(decorators, (String)" -> "));
        }
        this.decorateResource((Resource)project, decorators, true);
    }

    private DecoratorContext decorateResource(Resource resource, Collection<Decorator> decorators, boolean executeDecorators) {
        ArrayList<DecoratorContext> childrenContexts = new ArrayList<DecoratorContext>();
        Iterator<Resource> i$ = this.index.getChildren(resource).iterator();
        while (i$.hasNext()) {
            Resource child;
            boolean isModule = (child = i$.next()) instanceof Project;
            DefaultDecoratorContext childContext = (DefaultDecoratorContext)this.decorateResource(child, decorators, !isModule);
            childrenContexts.add(childContext.setReadOnly(true));
        }
        DefaultDecoratorContext context = new DefaultDecoratorContext(resource, this.index, childrenContexts, this.session, this.violationsDao);
        if (executeDecorators) {
            for (Decorator decorator : decorators) {
                decorator.decorate(resource, (DecoratorContext)context);
            }
        }
        return context;
    }
}

