/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Bucket {
    private Resource resource;
    private ListMultimap<String, Measure> measuresByMetric = ArrayListMultimap.create();
    private List<Violation> violations = Lists.newLinkedList();
    private Bucket parent;
    private List<Bucket> children;

    public Bucket(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Bucket setParent(Bucket parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        return this;
    }

    private Bucket addChild(Bucket child) {
        if (this.children == null) {
            this.children = Lists.newArrayList();
        }
        this.children.add(child);
        return this;
    }

    private void removeChild(Bucket child) {
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    public List<Bucket> getChildren() {
        return this.children == null ? Collections.emptyList() : this.children;
    }

    public Bucket getParent() {
        return this.parent;
    }

    public void addViolation(Violation violation) {
        this.violations.add(violation);
    }

    public List<Violation> getViolations() {
        return this.violations;
    }

    public void addMeasure(Measure measure) {
        int index;
        List metricMeasures = this.measuresByMetric.get((Object)measure.getMetric().getKey());
        boolean add = true;
        if (metricMeasures != null && (index = metricMeasures.indexOf(measure)) > -1) {
            if (metricMeasures.get(index) == measure) {
                add = false;
            } else {
                throw new SonarException("Can not add twice the same measure on " + this.resource + ": " + measure);
            }
        }
        if (add) {
            this.measuresByMetric.put((Object)measure.getMetric().getKey(), (Object)measure);
        }
    }

    public void clear() {
        this.measuresByMetric = null;
        this.violations = null;
        this.children = null;
        if (this.parent != null) {
            this.parent.removeChild(this);
            this.parent = null;
        }
    }

    public <M> M getMeasures(MeasuresFilter<M> filter) {
        Collection unfiltered = filter instanceof MeasuresFilters.MetricFilter ? this.measuresByMetric.get((Object)((MeasuresFilters.MetricFilter)filter).filterOnMetricKey()) : this.measuresByMetric.values();
        return (M)filter.filter(unfiltered);
    }

    public boolean isExcluded() {
        return this.resource.isExcluded();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bucket that = (Bucket)o;
        return this.resource.equals((Object)that.resource);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }
}

