/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.collect.Sets;
import java.util.Set;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.database.model.SnapshotSource;
import org.sonar.api.resources.DuplicatedSourceException;
import org.sonar.api.resources.Resource;
import org.sonar.batch.index.ResourcePersister;

public final class SourcePersister {
    private DatabaseSession session;
    private Set<Integer> savedSnapshotIds = Sets.newHashSet();
    private ResourcePersister resourcePersister;

    public SourcePersister(DatabaseSession session, ResourcePersister resourcePersister) {
        this.session = session;
        this.resourcePersister = resourcePersister;
    }

    public void saveSource(Resource resource, String source) {
        Snapshot snapshot = this.resourcePersister.getSnapshotOrFail(resource);
        if (this.isCached(snapshot)) {
            throw new DuplicatedSourceException(resource);
        }
        this.session.save((Object)new SnapshotSource(snapshot.getId(), source));
        this.session.commit();
        this.addToCache(snapshot);
    }

    public String getSource(Resource resource) {
        SnapshotSource source = null;
        Snapshot snapshot = this.resourcePersister.getSnapshot(resource);
        if (snapshot != null && snapshot.getId() != null) {
            source = (SnapshotSource)this.session.getSingleResult(SnapshotSource.class, new Object[]{"snapshotId", snapshot.getId()});
        }
        return source != null ? source.getData() : null;
    }

    private boolean isCached(Snapshot snapshot) {
        return this.savedSnapshotIds.contains(snapshot.getId());
    }

    private void addToCache(Snapshot snapshot) {
        this.savedSnapshotIds.add(snapshot.getId());
    }

    public void clear() {
        this.savedSnapshotIds.clear();
    }
}

