/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.Semaphores;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.bootstrap.DurationLabel;

public class ProjectLock {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectLock.class);
    private final Semaphores semaphores;
    private final ProjectTree projectTree;
    private final Settings settings;

    public ProjectLock(Semaphores semaphores, ProjectTree projectTree, Settings settings) {
        this.semaphores = semaphores;
        this.projectTree = projectTree;
        this.settings = settings;
    }

    public void start() {
        Semaphores.Semaphore semaphore;
        if (!this.isInDryRunMode() && !(semaphore = this.acquire()).isLocked()) {
            LOG.error(this.getErrorMessage(semaphore));
            throw new SonarException("The project is already been analysing.");
        }
    }

    private String getErrorMessage(Semaphores.Semaphore semaphore) {
        long duration = semaphore.getDurationSinceLocked();
        DurationLabel durationLabel = new DurationLabel();
        String durationDisplay = durationLabel.label(duration);
        return "It looks like an analysis of '" + this.getProject().getName() + "' is already running (started " + durationDisplay + "). " + "If this is not the case, it probably means that previous analysis was interrupted " + "and you should then force a re-run by using the option '" + "sonar.forceAnalysis" + "=true'.";
    }

    public void stop() {
        if (!this.isInDryRunMode()) {
            this.release();
        }
    }

    private Semaphores.Semaphore acquire() {
        LOG.debug("Acquire semaphore on project : {}, with key {}", (Object)this.getProject(), (Object)this.getSemaphoreKey());
        if (this.shouldForce()) {
            return this.semaphores.acquire(this.getSemaphoreKey(), 0);
        }
        return this.semaphores.acquire(this.getSemaphoreKey());
    }

    private void release() {
        LOG.debug("Release semaphore on project : {}, with key {}", (Object)this.getProject(), (Object)this.getSemaphoreKey());
        this.semaphores.release(this.getSemaphoreKey());
    }

    private String getSemaphoreKey() {
        return "batch-" + this.getProject().getKey();
    }

    private Project getProject() {
        return this.projectTree.getRootProject();
    }

    private boolean isInDryRunMode() {
        return this.settings.getBoolean("sonar.dryRun");
    }

    private boolean shouldForce() {
        return this.settings.getBoolean("sonar.forceAnalysis");
    }
}

