/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.config.Settings;
import org.sonar.batch.bootstrap.BatchSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSettings
extends Settings {
    private Configuration deprecatedCommonsConf;

    public ProjectSettings(BatchSettings batchSettings, ProjectDefinition project, Configuration deprecatedCommonsConf) {
        super(batchSettings.getDefinitions());
        LoggerFactory.getLogger(ProjectSettings.class).info("Load module settings");
        this.deprecatedCommonsConf = deprecatedCommonsConf;
        this.init(project, batchSettings);
    }

    private ProjectSettings init(ProjectDefinition project, BatchSettings batchSettings) {
        this.addProjectProperties(project, batchSettings);
        this.addBuildProperties(project);
        this.addEnvironmentVariables();
        this.addSystemProperties();
        return this;
    }

    private void addProjectProperties(ProjectDefinition project, BatchSettings batchSettings) {
        String branch = batchSettings.getString("sonar.branch");
        String projectKey = project.getKey();
        if (StringUtils.isNotBlank((String)branch)) {
            projectKey = String.format("%s:%s", projectKey, branch);
        }
        this.addProperties(batchSettings.getProperties());
        Map<String, String> moduleProps = batchSettings.getModuleProperties(projectKey);
        if (moduleProps != null) {
            for (Map.Entry<String, String> entry : moduleProps.entrySet()) {
                this.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    private void addBuildProperties(ProjectDefinition project) {
        List<ProjectDefinition> orderedProjects = ProjectSettings.getTopDownParentProjects(project);
        for (ProjectDefinition p : orderedProjects) {
            this.addProperties(p.getProperties());
        }
    }

    static List<ProjectDefinition> getTopDownParentProjects(ProjectDefinition project) {
        ArrayList result = Lists.newArrayList();
        for (ProjectDefinition p = project; p != null; p = p.getParent()) {
            result.add(0, p);
        }
        return result;
    }

    protected void doOnSetProperty(String key, @Nullable String value) {
        this.deprecatedCommonsConf.setProperty(key, (Object)value);
    }

    protected void doOnRemoveProperty(String key) {
        this.deprecatedCommonsConf.clearProperty(key);
    }

    protected void doOnClearProperties() {
        this.deprecatedCommonsConf.clear();
    }
}

