/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrapper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.batch.bootstrap.BootstrapModule;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.bootstrapper.LoggingConfiguration;
import org.sonar.core.PicoUtils;

public final class Batch {
    private LoggingConfiguration logging;
    private List<Object> components = Lists.newArrayList();
    private ProjectReactor projectReactor;

    private Batch(Builder builder) {
        this.components.addAll(builder.components);
        this.components.add(builder.environment);
        this.projectReactor = builder.projectReactor;
        if (builder.isEnableLoggingConfiguration()) {
            this.logging = LoggingConfiguration.create().setProperties((Map<String, String>)Maps.fromProperties((Properties)this.projectReactor.getRoot().getProperties()));
        }
    }

    public LoggingConfiguration getLoggingConfiguration() {
        return this.logging;
    }

    public Batch execute() {
        this.configureLogging();
        this.startBatch();
        return this;
    }

    private void configureLogging() {
        if (this.logging != null) {
            this.logging.configure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBatch() {
        Module bootstrapModule = null;
        try {
            bootstrapModule = new BootstrapModule(this.projectReactor, this.components.toArray(new Object[this.components.size()]));
            bootstrapModule.init();
            bootstrapModule.start();
        }
        catch (RuntimeException e) {
            PicoUtils.propagateStartupException((Throwable)e);
        }
        finally {
            try {
                if (bootstrapModule != null) {
                    bootstrapModule.stop();
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(Batch.class).error("Error while stopping batch", (Throwable)e);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        private ProjectReactor projectReactor;
        private EnvironmentInformation environment;
        private List<Object> components = Lists.newArrayList();
        private boolean enableLoggingConfiguration = true;

        private Builder() {
        }

        public Builder setProjectReactor(ProjectReactor projectReactor) {
            this.projectReactor = projectReactor;
            return this;
        }

        public Builder setEnvironment(EnvironmentInformation env) {
            this.environment = env;
            return this;
        }

        public Builder setComponents(List<Object> l) {
            this.components = l;
            return this;
        }

        public Builder addComponents(Object ... components) {
            Collections.addAll(this.components, components);
            return this;
        }

        public Builder addComponent(Object component) {
            this.components.add(component);
            return this;
        }

        public boolean isEnableLoggingConfiguration() {
            return this.enableLoggingConfiguration;
        }

        public Builder setEnableLoggingConfiguration(boolean b) {
            this.enableLoggingConfiguration = b;
            return this;
        }

        public Batch build() {
            if (this.projectReactor == null) {
                throw new IllegalStateException("ProjectReactor is not set");
            }
            if (this.environment == null) {
                throw new IllegalStateException("EnvironmentInfo is not set");
            }
            if (this.components == null) {
                throw new IllegalStateException("Batch components are not set");
            }
            return new Batch(this);
        }
    }
}

