/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.tasks;

import org.sonar.api.task.Task;
import org.sonar.api.task.TaskDefinition;
import org.sonar.batch.tasks.Tasks;

public class ListTasksTask
implements Task {
    public static final String COMMAND = "list-tasks";
    public static final TaskDefinition DEFINITION = TaskDefinition.create().setDescription("List available tasks").setName("List Tasks").setCommand("list-tasks").setTask(ListTasksTask.class);
    private final Tasks taskManager;

    public ListTasksTask(Tasks taskManager) {
        this.taskManager = taskManager;
    }

    public void execute() {
        this.logBlankLine();
        this.log("Available tasks:");
        this.logBlankLine();
        for (TaskDefinition taskDef : this.taskManager.getTaskDefinitions()) {
            this.log("  - " + taskDef.getCommand() + ": " + taskDef.getDescription());
        }
        this.logBlankLine();
    }

    void log(String s) {
        System.out.println(s);
    }

    void logBlankLine() {
        System.out.println();
    }
}

