/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.tasks;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Settings;
import org.sonar.api.task.Task;
import org.sonar.api.task.TaskComponent;
import org.sonar.api.task.TaskDefinition;
import org.sonar.api.utils.SonarException;

public class Tasks
implements TaskComponent {
    private static final Logger LOG = LoggerFactory.getLogger(Tasks.class);
    private static final String COMMAND_PATTERN = "[a-zA-Z0-9\\-\\_]+";
    private final TaskDefinition[] taskDefinitions;
    private final Settings settings;
    private final Map<String, TaskDefinition> taskDefByCommand = new HashMap<String, TaskDefinition>();
    private final Map<Class<? extends Task>, TaskDefinition> taskDefByTask = new HashMap<Class<? extends Task>, TaskDefinition>();

    public Tasks(Settings settings, TaskDefinition[] taskDefinitions) {
        this.settings = settings;
        this.taskDefinitions = taskDefinitions;
    }

    public TaskDefinition getTaskDefinition(@Nullable String command) {
        String finalCommand = command;
        if (StringUtils.isBlank((String)finalCommand)) {
            finalCommand = this.settings.getString("sonar.task");
        }
        String string = finalCommand = StringUtils.isNotBlank((String)finalCommand) ? finalCommand : "inspect";
        if (this.taskDefByCommand.containsKey(finalCommand)) {
            return this.taskDefByCommand.get(finalCommand);
        }
        throw new SonarException("No task found for command: " + finalCommand);
    }

    public TaskDefinition[] getTaskDefinitions() {
        return this.taskDefinitions;
    }

    public void start() {
        for (TaskDefinition def : this.taskDefinitions) {
            this.validateTask(def);
            this.validateName(def);
            this.validateCommand(def);
            this.validateDescription(def);
        }
    }

    private void validateName(TaskDefinition def) {
        if (StringUtils.isBlank((String)def.getName())) {
            throw new SonarException("Task definition for task '" + def.getTask().getName() + "' doesn't define task name");
        }
    }

    private void validateCommand(TaskDefinition def) {
        String command = def.getCommand();
        if (StringUtils.isBlank((String)command)) {
            throw new SonarException("Task definition '" + def.getName() + "' doesn't define task command");
        }
        if (!Pattern.matches(COMMAND_PATTERN, command)) {
            throw new SonarException("Command '" + command + "' for task definition '" + def.getName() + "' is not valid and should match " + COMMAND_PATTERN);
        }
        if (this.taskDefByCommand.containsKey(command)) {
            throw new SonarException("Task '" + def.getName() + "' uses the same command than task '" + this.taskDefByCommand.get(command).getName() + "'");
        }
        this.taskDefByCommand.put(command, def);
    }

    private void validateDescription(TaskDefinition def) {
        if (StringUtils.isBlank((String)def.getDescription())) {
            LOG.warn("Task definition {} doesn't define a description. Using name as description.", (Object)def.getName());
            def.setDescription(def.getName());
        }
    }

    private void validateTask(TaskDefinition def) {
        Class taskClass = def.getTask();
        if (taskClass == null) {
            throw new SonarException("Task definition '" + def.getName() + "' doesn't define the associated task class");
        }
        if (this.taskDefByTask.containsKey(taskClass)) {
            throw new SonarException("Task '" + def.getTask().getName() + "' is defined twice: first by '" + this.taskDefByTask.get(taskClass).getName() + "' and then by '" + def.getName() + "'");
        }
        this.taskDefByTask.put(taskClass, def);
    }
}

