/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.WildcardPattern;

public class Directory
extends Resource {
    public static final String SEPARATOR = "/";
    public static final String ROOT = "[root]";
    private Language language;

    public Directory(String key) {
        this(key, null);
    }

    public Directory(String key, Language language) {
        this.setKey(Directory.parseKey(key));
        this.language = language;
    }

    public String getName() {
        return this.getKey();
    }

    public String getLongName() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getScope() {
        return "DIR";
    }

    public String getQualifier() {
        return "DIR";
    }

    public Resource getParent() {
        return null;
    }

    public boolean matchFilePattern(String antPattern) {
        WildcardPattern matcher = WildcardPattern.create(antPattern, SEPARATOR);
        return matcher.match(this.getKey());
    }

    public static String parseKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            return ROOT;
        }
        key = key.replace('\\', '/');
        key = StringUtils.trim((String)key);
        key = StringUtils.removeStart((String)key, (String)SEPARATOR);
        key = StringUtils.removeEnd((String)key, (String)SEPARATOR);
        return key;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.getKey()).append("language", (Object)this.language).toString();
    }
}

