/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.database.BaseIdentifiable;
import org.sonar.api.database.model.ResourceModel;

@Entity(name="ProjectLink")
@Table(name="project_links")
public class ProjectLink
extends BaseIdentifiable {
    public static final int NAME_COLUMN_SIZE = 128;
    public static final int HREF_COLUMN_SIZE = 2048;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="project_id", updatable=false, nullable=false)
    private ResourceModel resource;
    @Column(name="link_type", updatable=true, nullable=true, length=20)
    private String key;
    @Column(name="name", updatable=true, nullable=true, length=128)
    private String name;
    @Column(name="href", updatable=true, nullable=false, length=2048)
    private String href;

    public ProjectLink() {
    }

    public ProjectLink(String key, String name, String href) {
        this.key = key;
        this.setName(name);
        this.setHref(href);
    }

    public ResourceModel getResource() {
        return this.resource;
    }

    public void setResource(ResourceModel resource) {
        this.resource = resource;
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = StringUtils.abbreviate((String)name, (int)128);
    }

    public String getHref() {
        return this.href;
    }

    public final void setHref(String href) {
        if (href == null) {
            throw new IllegalArgumentException("ProjectLink.href can not be null");
        }
        this.href = StringUtils.abbreviate((String)href, (int)2048);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectLink that = (ProjectLink)o;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.resource.equals(that.resource);
    }

    public int hashCode() {
        int result = this.resource != null ? this.resource.hashCode() : 0;
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
    }

    public void copyFieldsFrom(ProjectLink link) {
        this.name = link.getName();
        this.href = link.getHref();
    }
}

