/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRuleParam;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="active_rules")
public class ActiveRule
implements Cloneable {
    public static final String INHERITED = "INHERITED";
    public static final String OVERRIDES = "OVERRIDES";
    @Id
    @Column(name="id")
    @GeneratedValue
    private Integer id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="rule_id", updatable=true, nullable=false)
    private Rule rule;
    @Column(name="failure_level", updatable=true, nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private RulePriority severity;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="profile_id", updatable=true, nullable=false)
    private RulesProfile rulesProfile;
    @OneToMany(mappedBy="activeRule", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    private List<ActiveRuleParam> activeRuleParams = new ArrayList<ActiveRuleParam>();
    @Column(name="inheritance", updatable=true, nullable=true)
    private String inheritance;

    @Deprecated
    public ActiveRule() {
    }

    @Deprecated
    public ActiveRule(RulesProfile profile, Rule rule, RulePriority severity) {
        this.rule = rule;
        this.severity = severity == null && rule != null ? rule.getSeverity() : severity;
        this.rulesProfile = profile;
    }

    public Integer getId() {
        return this.id;
    }

    public String getInheritance() {
        return this.inheritance;
    }

    public void setInheritance(String s) {
        this.inheritance = s;
    }

    public boolean isInherited() {
        return StringUtils.equals((String)INHERITED, (String)this.inheritance);
    }

    public boolean doesOverride() {
        return StringUtils.equals((String)OVERRIDES, (String)this.inheritance);
    }

    @Deprecated
    public void setId(Integer id) {
        this.id = id;
    }

    public Rule getRule() {
        return this.rule;
    }

    @Deprecated
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public RulePriority getSeverity() {
        return this.severity;
    }

    public void setSeverity(RulePriority severity) {
        this.severity = severity;
    }

    @Deprecated
    public RulePriority getPriority() {
        return this.severity;
    }

    @Deprecated
    public void setPriority(RulePriority priority) {
        this.severity = priority;
    }

    public RulesProfile getRulesProfile() {
        return this.rulesProfile;
    }

    @Deprecated
    public void setRulesProfile(RulesProfile rulesProfile) {
        this.rulesProfile = rulesProfile;
    }

    public List<ActiveRuleParam> getActiveRuleParams() {
        return this.activeRuleParams;
    }

    @Deprecated
    public void setActiveRuleParams(List<ActiveRuleParam> params) {
        this.activeRuleParams = params;
    }

    public ActiveRule setParameter(String key, String value) {
        RuleParam ruleParameter = this.rule.getParam(key);
        if (ruleParameter != null) {
            this.activeRuleParams.add(new ActiveRuleParam(this, ruleParameter, value));
        }
        return this;
    }

    public String getParameter(String key) {
        if (this.activeRuleParams != null) {
            for (ActiveRuleParam param : this.activeRuleParams) {
                if (!StringUtils.equals((String)key, (String)param.getKey())) continue;
                return param.getValue();
            }
        }
        return null;
    }

    @Deprecated
    public String getPluginName() {
        return this.rule.getRepositoryKey();
    }

    public String getRepositoryKey() {
        return this.rule.getRepositoryKey();
    }

    public String getConfigKey() {
        return this.rule.getConfigKey();
    }

    public String getRuleKey() {
        return this.rule.getKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActiveRule that = (ActiveRule)o;
        if (!this.rule.equals(that.rule)) {
            return false;
        }
        return !(this.rulesProfile != null ? !this.rulesProfile.equals(that.rulesProfile) : that.rulesProfile != null);
    }

    public int hashCode() {
        int result = this.rule.hashCode();
        result = 31 * result + (this.rulesProfile != null ? this.rulesProfile.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("rule", (Object)this.rule).append("priority", (Object)this.severity).append("params", this.activeRuleParams).toString();
    }

    public Object clone() {
        final ActiveRule clone = new ActiveRule(this.getRulesProfile(), this.getRule(), this.getSeverity());
        clone.setInheritance(this.getInheritance());
        if (CollectionUtils.isNotEmpty(this.getActiveRuleParams())) {
            clone.setActiveRuleParams(new ArrayList<ActiveRuleParam>(CollectionUtils.collect(this.getActiveRuleParams(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    ActiveRuleParam activeRuleParamClone = (ActiveRuleParam)((ActiveRuleParam)input).clone();
                    activeRuleParamClone.setActiveRule(clone);
                    return activeRuleParamClone;
                }
            })));
        }
        return clone;
    }

    public boolean isEnabled() {
        return this.getRule() != null && this.getRule().isEnabled() != false;
    }
}

