/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.ServerComponent;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Check;
import org.sonar.check.CheckProperty;
import org.sonar.check.RuleProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationRuleParser
implements ServerComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationRuleParser.class);

    public List<Rule> parse(String repositoryKey, Collection<Class> annotatedClasses) {
        ArrayList rules = Lists.newArrayList();
        for (Class annotatedClass : annotatedClasses) {
            rules.add(this.create(repositoryKey, annotatedClass));
        }
        return rules;
    }

    private Rule create(String repositoryKey, Class annotatedClass) {
        org.sonar.check.Rule ruleAnnotation = AnnotationUtils.getClassAnnotation(annotatedClass, org.sonar.check.Rule.class);
        if (ruleAnnotation != null) {
            return this.toRule(repositoryKey, annotatedClass, ruleAnnotation);
        }
        Check checkAnnotation = AnnotationUtils.getClassAnnotation(annotatedClass, Check.class);
        if (checkAnnotation != null) {
            return this.toRule(repositoryKey, annotatedClass, checkAnnotation);
        }
        LOG.warn("The class " + annotatedClass.getCanonicalName() + " should be annotated with " + Rule.class);
        return null;
    }

    private Rule toRule(String repositoryKey, Class clazz, org.sonar.check.Rule ruleAnnotation) {
        String ruleKey = StringUtils.defaultIfEmpty((String)ruleAnnotation.key(), (String)clazz.getCanonicalName());
        String ruleName = StringUtils.defaultIfEmpty((String)ruleAnnotation.name(), null);
        String description = StringUtils.defaultIfEmpty((String)ruleAnnotation.description(), null);
        Rule rule = Rule.create(repositoryKey, ruleKey, ruleName);
        rule.setDescription(description);
        rule.setSeverity(RulePriority.fromCheckPriority(ruleAnnotation.priority()));
        rule.setCardinality(ruleAnnotation.cardinality());
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                this.addRuleProperty(rule, field);
            }
        }
        return rule;
    }

    private Rule toRule(String repositoryKey, Class clazz, Check checkAnnotation) {
        String ruleKey = StringUtils.defaultIfEmpty((String)checkAnnotation.key(), (String)clazz.getCanonicalName());
        String ruleName = StringUtils.defaultIfEmpty((String)checkAnnotation.title(), (String)ruleKey);
        Rule rule = Rule.create(repositoryKey, ruleKey, ruleName);
        rule.setDescription(checkAnnotation.description());
        rule.setSeverity(RulePriority.fromCheckPriority(checkAnnotation.priority()));
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                this.addCheckProperty(rule, field);
            }
        }
        return rule;
    }

    private void addRuleProperty(Rule rule, Field field) {
        RuleProperty propertyAnnotation = field.getAnnotation(RuleProperty.class);
        if (propertyAnnotation != null) {
            String fieldKey = StringUtils.defaultIfEmpty((String)propertyAnnotation.key(), (String)field.getName());
            RuleParam param = rule.createParameter(fieldKey);
            param.setDescription(propertyAnnotation.description());
            param.setDefaultValue(propertyAnnotation.defaultValue());
        }
    }

    private void addCheckProperty(Rule rule, Field field) {
        CheckProperty propertyAnnotation = field.getAnnotation(CheckProperty.class);
        if (propertyAnnotation != null) {
            String fieldKey = StringUtils.defaultIfEmpty((String)propertyAnnotation.key(), (String)field.getName());
            RuleParam param = rule.createParameter(fieldKey);
            param.setDescription(propertyAnnotation.description());
        }
    }
}

