/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.bootstrap;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDefinition {
    public static final String SOURCE_DIRS_PROPERTY = "sonar.sources";
    public static final String SOURCE_FILES_PROPERTY = "sonar.sourceFiles";
    public static final String TEST_DIRS_PROPERTY = "sonar.tests";
    public static final String TEST_FILES_PROPERTY = "sonar.testFiles";
    public static final String BINARIES_PROPERTY = "sonar.binaries";
    public static final String LIBRARIES_PROPERTY = "sonar.libraries";
    private static final char SEPARATOR = ',';
    private File baseDir;
    private File workDir;
    private Properties properties = new Properties();
    private ProjectDefinition parent = null;
    private List<ProjectDefinition> subProjects = Lists.newArrayList();
    private List<Object> containerExtensions = Lists.newArrayList();

    private ProjectDefinition(Properties p) {
        this.properties = p;
    }

    @Deprecated
    public static ProjectDefinition create(Properties properties) {
        return new ProjectDefinition(properties);
    }

    public static ProjectDefinition create() {
        return new ProjectDefinition(new Properties());
    }

    public ProjectDefinition setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public ProjectDefinition setWorkDir(File workDir) {
        this.workDir = workDir;
        return this;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ProjectDefinition setProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public ProjectDefinition setProperty(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public ProjectDefinition setKey(String key) {
        this.properties.setProperty("sonar.projectKey", key);
        return this;
    }

    public ProjectDefinition setVersion(String s) {
        this.properties.setProperty("sonar.projectVersion", StringUtils.defaultString((String)s));
        return this;
    }

    public ProjectDefinition setName(String s) {
        this.properties.setProperty("sonar.projectName", StringUtils.defaultString((String)s));
        return this;
    }

    public ProjectDefinition setDescription(String s) {
        this.properties.setProperty("sonar.projectDescription", StringUtils.defaultString((String)s));
        return this;
    }

    public String getKey() {
        return this.properties.getProperty("sonar.projectKey");
    }

    public String getVersion() {
        return this.properties.getProperty("sonar.projectVersion");
    }

    public String getName() {
        String name = this.properties.getProperty("sonar.projectName");
        if (StringUtils.isBlank((String)name)) {
            name = "Unnamed - " + this.getKey();
        }
        return name;
    }

    public String getDescription() {
        return this.properties.getProperty("sonar.projectDescription");
    }

    private void appendProperty(String key, String value) {
        String newValue = this.properties.getProperty(key, "") + ',' + value;
        this.properties.put(key, newValue);
    }

    public List<String> getSourceDirs() {
        String sources = this.properties.getProperty(SOURCE_DIRS_PROPERTY, "");
        return ProjectDefinition.trim(StringUtils.split((String)sources, (char)','));
    }

    public ProjectDefinition addSourceDirs(String ... paths) {
        for (String path : paths) {
            this.appendProperty(SOURCE_DIRS_PROPERTY, path);
        }
        return this;
    }

    public ProjectDefinition addSourceDirs(File ... dirs) {
        for (File dir : dirs) {
            this.addSourceDirs(dir.getAbsolutePath());
        }
        return this;
    }

    public ProjectDefinition resetSourceDirs() {
        this.properties.remove(SOURCE_DIRS_PROPERTY);
        return this;
    }

    public ProjectDefinition setSourceDirs(String ... paths) {
        this.resetSourceDirs();
        return this.addSourceDirs(paths);
    }

    public ProjectDefinition setSourceDirs(File ... dirs) {
        this.resetSourceDirs();
        for (File dir : dirs) {
            this.addSourceDirs(dir.getAbsolutePath());
        }
        return this;
    }

    public ProjectDefinition addSourceFiles(String ... paths) {
        for (String path : paths) {
            this.appendProperty(SOURCE_FILES_PROPERTY, path);
        }
        return this;
    }

    public ProjectDefinition addSourceFiles(File ... files) {
        for (File file : files) {
            this.addSourceFiles(file.getAbsolutePath());
        }
        return this;
    }

    public List<String> getSourceFiles() {
        String sources = this.properties.getProperty(SOURCE_FILES_PROPERTY, "");
        return ProjectDefinition.trim(StringUtils.split((String)sources, (char)','));
    }

    public List<String> getTestDirs() {
        String sources = this.properties.getProperty(TEST_DIRS_PROPERTY, "");
        return ProjectDefinition.trim(StringUtils.split((String)sources, (char)','));
    }

    public ProjectDefinition addTestDirs(String ... paths) {
        for (String path : paths) {
            this.appendProperty(TEST_DIRS_PROPERTY, path);
        }
        return this;
    }

    public ProjectDefinition addTestDirs(File ... dirs) {
        for (File dir : dirs) {
            this.addTestDirs(dir.getAbsolutePath());
        }
        return this;
    }

    public ProjectDefinition setTestDirs(String ... paths) {
        this.resetTestDirs();
        return this.addTestDirs(paths);
    }

    public ProjectDefinition setTestDirs(File ... dirs) {
        this.resetTestDirs();
        for (File dir : dirs) {
            this.addTestDirs(dir.getAbsolutePath());
        }
        return this;
    }

    public ProjectDefinition resetTestDirs() {
        this.properties.remove(TEST_DIRS_PROPERTY);
        return this;
    }

    public ProjectDefinition addTestFiles(String ... paths) {
        for (String path : paths) {
            this.appendProperty(TEST_FILES_PROPERTY, path);
        }
        return this;
    }

    public ProjectDefinition addTestFiles(File ... files) {
        for (File file : files) {
            this.addTestFiles(file.getAbsolutePath());
        }
        return this;
    }

    public List<String> getTestFiles() {
        String sources = this.properties.getProperty(TEST_FILES_PROPERTY, "");
        return ProjectDefinition.trim(StringUtils.split((String)sources, (char)','));
    }

    public List<String> getBinaries() {
        String sources = this.properties.getProperty(BINARIES_PROPERTY, "");
        return ProjectDefinition.trim(StringUtils.split((String)sources, (char)','));
    }

    public ProjectDefinition addBinaryDir(String path) {
        this.appendProperty(BINARIES_PROPERTY, path);
        return this;
    }

    public ProjectDefinition addBinaryDir(File f) {
        return this.addBinaryDir(f.getAbsolutePath());
    }

    public List<String> getLibraries() {
        String sources = this.properties.getProperty(LIBRARIES_PROPERTY, "");
        return ProjectDefinition.trim(StringUtils.split((String)sources, (char)','));
    }

    public void addLibrary(String path) {
        this.appendProperty(LIBRARIES_PROPERTY, path);
    }

    public ProjectDefinition addContainerExtension(Object extension) {
        this.containerExtensions.add(extension);
        return this;
    }

    public List<Object> getContainerExtensions() {
        return this.containerExtensions;
    }

    public ProjectDefinition addSubProject(ProjectDefinition child) {
        this.subProjects.add(child);
        child.setParent(this);
        return this;
    }

    public ProjectDefinition getParent() {
        return this.parent;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.subProjects.remove(this);
            this.parent = null;
            this.subProjects.clear();
        }
    }

    private void setParent(ProjectDefinition parent) {
        this.parent = parent;
    }

    public List<ProjectDefinition> getSubProjects() {
        return this.subProjects;
    }

    private static List<String> trim(String[] strings) {
        ArrayList result = Lists.newArrayList();
        for (String s : strings) {
            result.add(StringUtils.trim((String)s));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectDefinition that = (ProjectDefinition)o;
        String key = this.getKey();
        return !(key != null ? !key.equals(that.getKey()) : that.getKey() != null);
    }

    public int hashCode() {
        String key = this.getKey();
        return key != null ? key.hashCode() : 0;
    }
}

