/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.api.profiles.Alert;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulePriority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="rules_profiles")
public class RulesProfile
implements Cloneable {
    public static final String SONAR_WAY_NAME = "Sonar way";
    public static final String SONAR_WAY_FINDBUGS_NAME = "Sonar way with Findbugs";
    public static final String SUN_CONVENTIONS_NAME = "Sun checks";
    @Id
    @Column(name="id")
    @GeneratedValue
    private Integer id;
    @Column(name="name", updatable=true, nullable=false)
    private String name;
    @Column(name="version", updatable=true, nullable=false)
    private int version = 1;
    @Transient
    private Boolean defaultProfile = Boolean.FALSE;
    @Column(name="used_profile", updatable=true, nullable=false)
    private Boolean used = Boolean.FALSE;
    @Column(name="language", updatable=true, nullable=false, length=20)
    private String language;
    @Column(name="parent_name", updatable=true, nullable=true)
    private String parentName;
    @OneToMany(mappedBy="rulesProfile", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    private List<ActiveRule> activeRules = Lists.newArrayList();
    @OneToMany(mappedBy="rulesProfile", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    private List<Alert> alerts = Lists.newArrayList();

    @Deprecated
    public RulesProfile() {
    }

    @Deprecated
    public RulesProfile(String name, String language) {
        this.name = name;
        this.language = language;
        this.activeRules = Lists.newArrayList();
        this.alerts = Lists.newArrayList();
    }

    @Deprecated
    public RulesProfile(String name, String language, boolean defaultProfile, boolean provided) {
        this(name, language);
        this.defaultProfile = defaultProfile;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public RulesProfile setName(String s) {
        this.name = s;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public RulesProfile setVersion(int version) {
        this.version = version;
        return this;
    }

    public Boolean getUsed() {
        return this.used;
    }

    public RulesProfile setUsed(Boolean used) {
        this.used = used;
        return this;
    }

    public List<ActiveRule> getActiveRules() {
        return this.getActiveRules(false);
    }

    public List<ActiveRule> getActiveRules(boolean acceptDisabledRules) {
        if (acceptDisabledRules) {
            return this.activeRules;
        }
        ArrayList result = Lists.newArrayList();
        for (ActiveRule activeRule : this.activeRules) {
            if (!activeRule.isEnabled()) continue;
            result.add(activeRule);
        }
        return result;
    }

    public RulesProfile removeActiveRule(ActiveRule activeRule) {
        this.activeRules.remove(activeRule);
        return this;
    }

    public RulesProfile addActiveRule(ActiveRule activeRule) {
        this.activeRules.add(activeRule);
        return this;
    }

    public void setActiveRules(List<ActiveRule> activeRules) {
        this.activeRules = activeRules;
    }

    public Boolean getDefaultProfile() {
        return this.defaultProfile;
    }

    public void setDefaultProfile(Boolean b) {
        this.defaultProfile = b;
    }

    @Deprecated
    public Boolean getProvided() {
        return false;
    }

    @Deprecated
    public void setProvided(Boolean b) {
    }

    @Deprecated
    public Boolean getEnabled() {
        return Boolean.TRUE;
    }

    @Deprecated
    public boolean isEnabled() {
        return true;
    }

    @Deprecated
    public RulesProfile setEnabled(Boolean b) {
        throw new UnsupportedOperationException("The field RulesProfile#enabled is not supported since 3.3.");
    }

    public String getLanguage() {
        return this.language;
    }

    public RulesProfile setLanguage(String s) {
        this.language = s;
        return this;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public List<Alert> getAlerts() {
        return this.alerts;
    }

    public void setAlerts(List<Alert> alerts) {
        this.alerts = alerts;
    }

    public List<ActiveRule> getActiveRules(RulePriority severity) {
        ArrayList result = Lists.newArrayList();
        for (ActiveRule activeRule : this.activeRules) {
            if (!activeRule.getSeverity().equals((Object)severity) || !activeRule.isEnabled()) continue;
            result.add(activeRule);
        }
        return result;
    }

    @Deprecated
    public List<ActiveRule> getActiveRulesByPlugin(String repositoryKey) {
        return this.getActiveRulesByRepository(repositoryKey);
    }

    public List<ActiveRule> getActiveRulesByRepository(String repositoryKey) {
        ArrayList result = Lists.newArrayList();
        for (ActiveRule activeRule : this.activeRules) {
            if (!repositoryKey.equals(activeRule.getRepositoryKey()) || !activeRule.isEnabled()) continue;
            result.add(activeRule);
        }
        return result;
    }

    public ActiveRule getActiveRule(String repositoryKey, String ruleKey) {
        for (ActiveRule activeRule : this.activeRules) {
            if (!StringUtils.equals((String)activeRule.getRepositoryKey(), (String)repositoryKey) || !StringUtils.equals((String)activeRule.getRuleKey(), (String)ruleKey) || !activeRule.isEnabled()) continue;
            return activeRule;
        }
        return null;
    }

    public ActiveRule getActiveRuleByConfigKey(String repositoryKey, String configKey) {
        for (ActiveRule activeRule : this.activeRules) {
            if (!StringUtils.equals((String)activeRule.getRepositoryKey(), (String)repositoryKey) || !StringUtils.equals((String)activeRule.getConfigKey(), (String)configKey) || !activeRule.isEnabled()) continue;
            return activeRule;
        }
        return null;
    }

    public ActiveRule getActiveRule(Rule rule) {
        return this.getActiveRule(rule.getRepositoryKey(), rule.getKey());
    }

    public ActiveRule activateRule(Rule rule, RulePriority optionalSeverity) {
        ActiveRule activeRule = new ActiveRule();
        activeRule.setRule(rule);
        activeRule.setRulesProfile(this);
        activeRule.setSeverity(optionalSeverity == null ? rule.getSeverity() : optionalSeverity);
        this.activeRules.add(activeRule);
        return activeRule;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RulesProfile)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RulesProfile other = (RulesProfile)obj;
        return new EqualsBuilder().append((Object)this.language, (Object)other.getLanguage()).append((Object)this.name, (Object)other.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.language).append((Object)this.name).toHashCode();
    }

    public Object clone() {
        RulesProfile clone = RulesProfile.create(this.getName(), this.getLanguage());
        clone.setDefaultProfile(this.getDefaultProfile());
        clone.setParentName(this.getParentName());
        if (this.activeRules != null && !this.activeRules.isEmpty()) {
            clone.setActiveRules(new ArrayList<ActiveRule>(CollectionUtils.collect(this.activeRules, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ((ActiveRule)input).clone();
                }
            })));
        }
        if (CollectionUtils.isNotEmpty(this.getAlerts())) {
            clone.setAlerts(new ArrayList<Alert>(CollectionUtils.collect(this.getAlerts(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ((Alert)input).clone();
                }
            })));
        }
        return clone;
    }

    public String toString() {
        return "[name=" + this.name + ",language=" + this.language + "]";
    }

    public static RulesProfile create(String name, String language) {
        return new RulesProfile().setName(name).setLanguage(language);
    }

    public static RulesProfile create() {
        return new RulesProfile();
    }
}

