/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.Java;
import org.sonar.api.resources.JavaPackage;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.WildcardPattern;

public class JavaFile
extends Resource<JavaPackage> {
    private String filename;
    private String longName;
    private String packageKey;
    private boolean unitTest;
    private JavaPackage parent;

    public JavaFile(String packageName, String className) {
        this(packageName, className, false);
    }

    public JavaFile(String packageKey, String className, boolean unitTest) {
        String key;
        if (className == null) {
            throw new IllegalArgumentException("Java filename can not be null");
        }
        this.filename = StringUtils.trim((String)className);
        if (StringUtils.isBlank((String)packageKey)) {
            this.packageKey = "[default]";
            this.longName = this.filename;
            key = this.packageKey + "." + this.filename;
        } else {
            this.packageKey = packageKey.trim();
            this.longName = key = this.packageKey + "." + this.filename;
        }
        this.setKey(key);
        this.unitTest = unitTest;
    }

    public JavaFile(String key) {
        this(key, false);
    }

    public JavaFile(String key, boolean unitTest) {
        if (key == null) {
            throw new IllegalArgumentException("Java filename can not be null");
        }
        String realKey = StringUtils.trim((String)key);
        this.unitTest = unitTest;
        if (realKey.contains(".")) {
            this.filename = StringUtils.substringAfterLast((String)realKey, (String)".");
            this.packageKey = StringUtils.substringBeforeLast((String)realKey, (String)".");
            this.longName = realKey;
        } else {
            this.filename = realKey;
            this.longName = realKey;
            this.packageKey = "[default]";
            realKey = "[default]" + "." + realKey;
        }
        this.setKey(realKey);
    }

    @Override
    public JavaPackage getParent() {
        if (this.parent == null) {
            this.parent = new JavaPackage(this.packageKey);
        }
        return this.parent;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Language getLanguage() {
        return Java.INSTANCE;
    }

    @Override
    public String getName() {
        return this.filename;
    }

    @Override
    public String getLongName() {
        return this.longName;
    }

    @Override
    public String getScope() {
        return "FIL";
    }

    @Override
    public String getQualifier() {
        return this.unitTest ? "UTS" : "CLA";
    }

    public boolean isUnitTest() {
        return this.unitTest;
    }

    @Override
    public boolean matchFilePattern(String antPattern) {
        String noPackagePrefix;
        String fileKey = this.getKey();
        if (!fileKey.endsWith(".java")) {
            fileKey = fileKey + ".java";
        }
        if (antPattern.contains("/") && StringUtils.substringAfterLast((String)antPattern, (String)"/").indexOf(46) < 0 || antPattern.indexOf(46) < 0) {
            antPattern = antPattern + ".*";
        }
        if (fileKey.startsWith(noPackagePrefix = "[default].")) {
            fileKey = fileKey.substring(noPackagePrefix.length());
        }
        WildcardPattern matcher = WildcardPattern.create(antPattern, ".");
        return matcher.match(fileKey);
    }

    public static JavaFile fromRelativePath(String relativePath, boolean unitTest) {
        if (relativePath != null) {
            String pacname = null;
            String classname = relativePath;
            if (relativePath.indexOf(47) >= 0) {
                pacname = StringUtils.substringBeforeLast((String)relativePath, (String)"/");
                pacname = StringUtils.replace((String)pacname, (String)"/", (String)".");
                classname = StringUtils.substringAfterLast((String)relativePath, (String)"/");
            }
            classname = StringUtils.substringBeforeLast((String)classname, (String)".");
            return new JavaFile(pacname, classname, unitTest);
        }
        return null;
    }

    public static JavaFile fromIOFile(File file, List<File> sourceDirs, boolean unitTest) {
        if (file == null || !StringUtils.endsWithIgnoreCase((String)file.getName(), (String)".java")) {
            return null;
        }
        PathResolver.RelativePath relativePath = new PathResolver().relativePath(sourceDirs, file);
        if (relativePath != null) {
            return JavaFile.fromRelativePath(relativePath.path(), unitTest);
        }
        return null;
    }

    public static JavaFile fromAbsolutePath(String path, List<File> sourceDirs, boolean unitTest) {
        if (path == null) {
            return null;
        }
        return JavaFile.fromIOFile(new File(path), sourceDirs, unitTest);
    }

    public String toString() {
        return this.getKey();
    }
}

