/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.maven.project.MavenProject;
import org.sonar.api.component.Component;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;

public class Project
extends Resource
implements Component {
    private static final String MAVEN_KEY_FORMAT = "%s:%s";
    private static final String BRANCH_KEY_FORMAT = "%s:%s";
    public static final String SCOPE = "PRJ";
    @Deprecated
    public static final String PARAM_REUSE_RULES_CONFIG = "sonar.reuseExistingRulesConfiguration";
    private MavenProject pom;
    private String branch;
    private ProjectFileSystem fileSystem;
    private Configuration configuration;
    private String name;
    private String description;
    private String packaging;
    private Language language;
    private Date analysisDate;
    private AnalysisType analysisType;
    private String analysisVersion;
    private Project parent;
    private List<Project> modules = new ArrayList<Project>();

    public Project(String key) {
        this.setKey(key);
        this.setEffectiveKey(key);
    }

    public Project(String key, String branch, String name) {
        if (StringUtils.isNotBlank((String)branch)) {
            this.setKey(String.format("%s:%s", key, branch));
            this.name = String.format("%s %s", name, branch);
        } else {
            this.setKey(key);
            this.name = name;
        }
        this.setEffectiveKey(this.getKey());
        this.branch = branch;
    }

    public String getBranch() {
        return this.branch;
    }

    public Project setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public final Project setPom(MavenProject pom) {
        this.pom = pom;
        return this;
    }

    @Deprecated
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLongName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Project setName(String name) {
        this.name = name;
        return this;
    }

    public Project setDescription(String description) {
        this.description = description;
        return this;
    }

    @Deprecated
    public Project setPackaging(String packaging) {
        this.packaging = packaging;
        return this;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public Project getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public boolean isModule() {
        return !this.isRoot();
    }

    public AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    public Project setAnalysisType(AnalysisType at) {
        this.analysisType = at;
        return this;
    }

    @Deprecated
    public boolean isLatestAnalysis() {
        return true;
    }

    @Deprecated
    public Project setLatestAnalysis(boolean b) {
        if (!b) {
            throw new UnsupportedOperationException("The analysis is always the latest one. Past analysis must be done in a chronological order.");
        }
        return this;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    public Project setLanguage(Language language) {
        this.language = language;
        return this;
    }

    public String getLanguageKey() {
        return this.configuration.getString("sonar.language", "java");
    }

    public Project setAnalysisDate(Date analysisDate) {
        this.analysisDate = analysisDate;
        return this;
    }

    public Project setAnalysisVersion(String analysisVersion) {
        this.analysisVersion = analysisVersion;
        return this;
    }

    @Override
    public String getScope() {
        return SCOPE;
    }

    @Override
    public String getQualifier() {
        return this.isRoot() ? "TRK" : "BRC";
    }

    @Override
    public boolean matchFilePattern(String antPattern) {
        return false;
    }

    public Project getParent() {
        return this.parent;
    }

    public Project setParent(Project parent) {
        this.parent = parent;
        if (parent != null) {
            parent.modules.add(this);
        }
        return this;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.modules.remove(this);
        }
    }

    public List<Project> getModules() {
        return this.modules;
    }

    @Deprecated
    public boolean getReuseExistingRulesConfig() {
        return this.configuration != null && this.configuration.getBoolean(PARAM_REUSE_RULES_CONFIG, false);
    }

    public String getAnalysisVersion() {
        return this.analysisVersion;
    }

    public Date getAnalysisDate() {
        return this.analysisDate;
    }

    @Deprecated
    public String[] getExclusionPatterns() {
        return Project.trimExclusions((List<String>)ImmutableList.builder().add((Object[])this.configuration.getStringArray("sonar.exclusions")).add((Object[])this.configuration.getStringArray("sonar.global.exclusions")).build());
    }

    @Deprecated
    public String[] getTestExclusionPatterns() {
        Object[] globalTestExclusions = this.configuration.getStringArray("sonar.global.test.exclusions");
        if (globalTestExclusions.length == 0) {
            globalTestExclusions = new String[]{"**/package-info.java"};
        }
        return Project.trimExclusions((List<String>)ImmutableList.builder().add((Object[])this.configuration.getStringArray("sonar.test.exclusions")).add(globalTestExclusions).build());
    }

    private static String[] trimExclusions(List<String> exclusions) {
        ArrayList trimmed = Lists.newArrayList();
        for (String exclusion : exclusions) {
            trimmed.add(StringUtils.trim((String)exclusion));
        }
        return trimmed.toArray(new String[trimmed.size()]);
    }

    @Deprecated
    public Project setExclusionPatterns(String[] s) {
        throw new UnsupportedOperationException("deprecated in 3.5");
    }

    @Deprecated
    public ProjectFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Deprecated
    public Project setFileSystem(ProjectFileSystem fs) {
        this.fileSystem = fs;
        return this;
    }

    @Deprecated
    public String getGroupId() {
        return this.pom.getGroupId();
    }

    @Deprecated
    public String getArtifactId() {
        return this.pom.getArtifactId();
    }

    @Deprecated
    public MavenProject getPom() {
        return this.pom;
    }

    @Deprecated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public final Project setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    @Deprecated
    public Object getProperty(String key) {
        return this.configuration != null ? this.configuration.getProperty(key) : null;
    }

    public static Project createFromMavenIds(String groupId, String artifactId) {
        return new Project(String.format("%s:%s", groupId, artifactId));
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("key", (Object)this.getKey()).append("qualifier", (Object)this.getQualifier()).toString();
    }

    @Override
    public String key() {
        return this.getKey();
    }

    @Override
    public String name() {
        return this.getName();
    }

    @Override
    public String longName() {
        return this.getLongName();
    }

    @Override
    public String qualifier() {
        return this.getQualifier();
    }

    public static enum AnalysisType {
        STATIC,
        DYNAMIC,
        REUSE_REPORTS;


        public boolean isDynamic(boolean includeReuseReportMode) {
            return this.equals((Object)DYNAMIC) || this.equals((Object)REUSE_REPORTS) && includeReuseReportMode;
        }
    }
}

